/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.content;

import com.lgmrszd.compressedcreativity.blocks.advanced_air_blower.AdvancedAirBlowerBlockEntity;
import com.lgmrszd.compressedcreativity.index.CCBlockPartials;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.Optional;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;

public class Mesh {

    public static interface IMeshType {
        default public boolean shouldTint() {
            return false;
        }

        default public int getTintColor(AdvancedAirBlowerBlockEntity te) {
            return -1;
        }

        default public Optional<PartialModel> getModel() {
            return Optional.empty();
        }

        default public Optional<PartialModel> getModelExtra() {
            return Optional.empty();
        }

        public String getName();

        default public Optional<FanProcessingType> getProcessingType(int temp) {
            return Optional.empty();
        }

        default public int getCoolingFactor() {
            return 1;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum MeshType implements IMeshType
    {
        SPLASHING("splashing", "Water Soaked Mesh"){

            @Override
            public boolean shouldTint() {
                return true;
            }

            @Override
            public int getTintColor(AdvancedAirBlowerBlockEntity te) {
                if (te.m_58904_() == null) {
                    return -1;
                }
                return BiomeColors.m_108811_((BlockAndTintGetter)te.m_58904_(), (BlockPos)te.m_58899_());
            }

            @Override
            public Optional<PartialModel> getModelExtra() {
                return Optional.ofNullable(CCBlockPartials.MESHES.get(1.WOVEN.name));
            }

            @Override
            public Optional<FanProcessingType> getProcessingType(int temp) {
                return Optional.of(AllFanProcessingTypes.SPLASHING);
            }
        }
        ,
        SPLASHING_FROZEN("splashing_frozen", "Frozen Mesh"){

            @Override
            public Optional<PartialModel> getModelExtra() {
                return Optional.empty();
            }
        }
        ,
        WOVEN("woven", "Woven Mesh"),
        DENSE("dense", "Dense Mesh"){

            @Override
            public boolean shouldTint() {
                return true;
            }

            @Override
            public int getTintColor(AdvancedAirBlowerBlockEntity te) {
                return te.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).map(cap -> HeatUtil.getColourForTemperature((int)cap.getTemperatureAsInt()).getRGB()).orElse(-1);
            }

            @Override
            public Optional<FanProcessingType> getProcessingType(int temp) {
                return temp > 373 ? Optional.of(AllFanProcessingTypes.BLASTING) : (temp > 323 ? Optional.of(AllFanProcessingTypes.SMOKING) : Optional.empty());
            }

            @Override
            public int getCoolingFactor() {
                return 2;
            }
        }
        ,
        HAUNTED("haunted", "Haunted Mesh"){

            @Override
            public Optional<FanProcessingType> getProcessingType(int temp) {
                return temp > 373 ? Optional.of(AllFanProcessingTypes.HAUNTING) : Optional.empty();
            }
        };

        private final String name;
        private final String displayName;

        private MeshType(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public Optional<PartialModel> getModel() {
            return Optional.ofNullable(CCBlockPartials.MESHES.get(this.name));
        }
    }
}

