/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.blocks.rotational_compressor;

import com.lgmrszd.compressedcreativity.blocks.common.IPneumaticTileEntity;
import com.lgmrszd.compressedcreativity.blocks.rotational_compressor.RotationalCompressorBlock;
import com.lgmrszd.compressedcreativity.config.CommonConfig;
import com.lgmrszd.compressedcreativity.config.PressureTierConfig;
import com.lgmrszd.compressedcreativity.index.CCLang;
import com.lgmrszd.compressedcreativity.network.IObserveTileEntity;
import com.lgmrszd.compressedcreativity.network.ObservePacket;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class RotationalCompressorBlockEntity
extends KineticBlockEntity
implements IObserveTileEntity,
IPneumaticTileEntity {
    protected final IAirHandlerMachine airHandler = PneumaticRegistry.getInstance().getAirHandlerMachineFactory().createAirHandler((PressureTier)PressureTierConfig.CustomTier.ROTATIONAL_COMPRESSOR_TIER, ((Integer)CommonConfig.ROTATIONAL_COMPRESSOR_VOLUME.get()).intValue());
    private final LazyOptional<IAirHandlerMachine> airHandlerCap = LazyOptional.of(() -> this.airHandler);
    private double airGeneratedPerTick = 0.0;
    private boolean updateGeneratedAir = true;
    private boolean isWrongDirection = false;
    private float airBuffer = 0.0f;

    public RotationalCompressorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        CCLang.translate("tooltip.pressure_summary", new Object[0]).forGoggles(tooltip);
        CCLang.translate("tooltip.pressure", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CCLang.number(this.airHandler.getPressure()).translate("unit.bar", new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        CCLang.translate("tooltip.air", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CCLang.number(this.airHandler.getAir()).translate("unit.air", new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        CCLang.translate("tooltip.air_production", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CCLang.number(this.airGeneratedPerTick).translate("unit.air_per_tick", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.f_58858_, 0);
        boolean added = super.addToTooltip(tooltip, isPlayerSneaking);
        if (this.isWrongDirection) {
            CCLang.translate("tooltip.rotational_compressor.wrong_direction", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
            CCLang.translate("tooltip.rotational_compressor.wrong_direction_desc", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            added = true;
        }
        return added;
    }

    public void initialize() {
        super.initialize();
        this.updateAirHandler();
    }

    public void invalidate() {
        super.invalidate();
        this.airHandlerCap.invalidate();
    }

    public void tick() {
        super.tick();
        this.airHandler.tick((BlockEntity)this);
        if (this.updateGeneratedAir) {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
            float speed = RotationalCompressorBlockEntity.convertToDirection((float)this.getSpeed(), (Direction)facing);
            this.isWrongDirection = speed < 0.0f;
            this.airGeneratedPerTick = speed > 0.0f && this.isSpeedRequirementFulfilled() ? (Double)CommonConfig.ROTATIONAL_COMPRESSOR_BASE_PRODUCTION.get() * (double)speed / 128.0 : 0.0;
            this.updateGeneratedAir = false;
            this.notifyUpdate();
        }
        if (this.m_58904_() != null && this.airGeneratedPerTick > 0.0) {
            if (!this.m_58904_().f_46443_) {
                this.airBuffer = (float)((double)this.airBuffer + this.airGeneratedPerTick);
                if (this.airBuffer >= 1.0f) {
                    int toAdd = (int)this.airBuffer;
                    this.airHandler.addAir(toAdd);
                    this.airBuffer -= (float)toAdd;
                }
            } else {
                this.spawnAirParticle();
            }
        }
    }

    private void spawnAirParticle() {
        if (this.m_58904_() == null) {
            return;
        }
        Direction orientation = (Direction)this.m_58900_().m_61143_(RotationalCompressorBlock.HORIZONTAL_FACING);
        if (this.m_58904_().f_46441_.m_188503_(5) == 0) {
            float px = (float)this.m_58899_().m_123341_() + 0.5f;
            float py = (float)this.m_58899_().m_123342_() + 0.5f + this.m_58904_().f_46441_.m_188501_() * 0.4f;
            float pz = (float)this.m_58899_().m_123343_() + 0.5f;
            float f3 = 0.9f;
            float f4 = this.m_58904_().f_46441_.m_188501_() * 0.4f;
            switch (orientation) {
                case EAST: {
                    this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)(px + f3), (double)py, (double)(pz + f4), -0.1, 0.0, 0.0);
                    break;
                }
                case WEST: {
                    this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)(px - f3), (double)py, (double)(pz + f4), 0.1, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)(px + f4), (double)py, (double)(pz + f3), 0.0, 0.0, -0.1);
                    break;
                }
                case NORTH: {
                    this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)(px + f4), (double)py, (double)(pz - f3), 0.0, 0.0, 0.1);
                }
            }
        }
    }

    public void updateAirHandler() {
        ArrayList<Direction> sides = new ArrayList<Direction>();
        for (Direction side : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}) {
            if (!this.canConnectPneumatic(side)) continue;
            sides.add(side);
        }
        this.airHandler.setConnectedFaces(sides);
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        this.updateGeneratedAir = true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY && this.canConnectPneumatic(side)) {
            return this.airHandlerCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean canConnectPneumatic(Direction dir) {
        Direction orientation = (Direction)this.m_58900_().m_61143_(RotationalCompressorBlock.HORIZONTAL_FACING);
        return dir != Direction.UP && dir != Direction.DOWN && dir != orientation && dir != orientation.m_122424_();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("AirHandler", this.airHandler.serializeNBT());
        if (clientPacket) {
            compound.m_128347_("airGeneratedPerTick", this.airGeneratedPerTick);
            compound.m_128379_("isWrongDirection", this.isWrongDirection);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.airHandler.deserializeNBT((Tag)compound.m_128469_("AirHandler"));
        if (clientPacket) {
            this.airGeneratedPerTick = compound.m_128459_("airGeneratedPerTick");
            this.isWrongDirection = compound.m_128471_("isWrongDirection");
        }
    }

    @Override
    public float getDangerPressure() {
        return this.airHandler.getDangerPressure();
    }
}

