/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.blocks.heater;

import com.lgmrszd.compressedcreativity.blocks.ITintedBlockEntity;
import com.lgmrszd.compressedcreativity.config.CommonConfig;
import com.lgmrszd.compressedcreativity.index.CCLang;
import com.lgmrszd.compressedcreativity.network.ForceUpdatePacket;
import com.lgmrszd.compressedcreativity.network.IUpdateBlockEntity;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class HeaterBlockEntity
extends SmartBlockEntity
implements ITintedBlockEntity,
IUpdateBlockEntity,
IHaveGoggleInformation {
    protected final IHeatExchangerLogic heatExchanger;
    private final LazyOptional<IHeatExchangerLogic> heatCap;
    private BlazeBurnerBlock.HeatLevel heatLevel = BlazeBurnerBlock.HeatLevel.NONE;

    public HeaterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
        this.heatExchanger.setThermalCapacity(((Double)CommonConfig.HEATER_THERMAL_CAPACITY.get()).doubleValue());
        this.heatExchanger.setThermalResistance(((Double)CommonConfig.HEATER_THERMAL_RESISTANCE.get()).doubleValue());
        this.heatCap = LazyOptional.of(() -> this.heatExchanger);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CCLang.translate("tooltip.heat_summary", new Object[0]).forGoggles(tooltip);
        CCLang.translate("tooltip.temperature", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CCLang.number(this.heatExchanger.getTemperature() - 273.0).translate("unit.temp", new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        CCLang.builder().text("[DEV] Debug info").forGoggles(tooltip);
        CCLang.builder().text(String.format("Cooling speed: %f heat/tick", this.getCoolingSpeed())).forGoggles(tooltip);
        CCLang.builder().text(String.format("Heat level: %s", this.heatLevel)).forGoggles(tooltip);
        CCLang.builder().text(String.format("Thermal capacity: %f", this.heatExchanger.getThermalCapacity())).forGoggles(tooltip);
        CCLang.builder().text(String.format("Thermal resistance: %f", this.heatExchanger.getThermalResistance())).forGoggles(tooltip);
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.HEAT_EXCHANGER_CAPABILITY && side != Direction.UP) {
            return this.heatCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void updateHeatExchanger() {
        Direction[] sides = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.DOWN};
        this.heatExchanger.initializeAsHull(this.m_58904_(), this.m_58899_(), (levelAccessor, blockPos) -> true, sides);
    }

    public void initialize() {
        super.initialize();
        this.updateHeatExchanger();
    }

    public double getCoolingSpeed() {
        double heat = (Double)CommonConfig.HEATER_TEMPERATURE_COEFFICIENT.get() * (this.heatExchanger.getTemperature() - (double)((Integer)CommonConfig.HEATER_STARTING_TEMPERATURE.get()).intValue() - 273.0);
        return heat > 0.0 ? heat : 0.0;
    }

    public void tick() {
        super.tick();
        boolean server = this.f_58857_ != null && !this.f_58857_.m_5776_();
        int oldTemp = this.heatExchanger.getTemperatureAsInt();
        if (server) {
            this.heatExchanger.tick();
            this.heatExchanger.addHeat(-this.getCoolingSpeed());
            int diff = Math.abs(this.heatExchanger.getTemperatureAsInt() - oldTemp);
            if (diff > 5) {
                this.updateTintServer();
                this.m_6596_();
                this.sendData();
            }
        }
        BlazeBurnerBlock.HeatLevel oldHeatLevel = this.heatLevel;
        this.updateHeatLevel();
        if (this.heatLevel != oldHeatLevel) {
            this.updateBlockHeat();
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.updateTintClient();
            return;
        }
        this.sendData();
    }

    public void updateTintClient() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 0);
        }
    }

    public void updateTintServer() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            ForceUpdatePacket.send(this.f_58857_, this.m_58899_());
        }
    }

    @Override
    public void forceUpdate() {
        this.updateTintClient();
    }

    public void invalidate() {
        super.invalidate();
        this.heatCap.invalidate();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("HeatExchanger", (Tag)this.heatExchanger.serializeNBT());
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.heatExchanger.deserializeNBT(compound.m_128469_("HeatExchanger"));
        super.read(compound, clientPacket);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    private void updateHeatLevel() {
        int temp = this.heatExchanger.getTemperatureAsInt() - 273;
        this.heatLevel = temp < (Integer)CommonConfig.HEATER_TEMPERATURE_PASSIVE.get() ? BlazeBurnerBlock.HeatLevel.NONE : (temp < (Integer)CommonConfig.HEATER_TEMPERATURE_KINDLED.get() ? BlazeBurnerBlock.HeatLevel.SMOULDERING : (temp < (Integer)CommonConfig.HEATER_TEMPERATURE_SEETHING.get() ? BlazeBurnerBlock.HeatLevel.KINDLED : BlazeBurnerBlock.HeatLevel.SEETHING));
    }

    private void updateBlockHeat() {
        BlockState blockState = this.m_58900_();
        BlazeBurnerBlock.HeatLevel oldHeatLevel = BlazeBurnerBlock.getHeatLevelOf((BlockState)blockState);
        if (oldHeatLevel == this.heatLevel) {
            return;
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)this.heatLevel));
        }
    }

    @Override
    public int getTintColor(int tintIndex) {
        if (tintIndex == 0) {
            return HeatUtil.getColourForTemperature((int)this.heatExchanger.getTemperatureAsInt()).getRGB();
        }
        return HeatUtil.getColourForTemperature((int)300).getRGB();
    }
}

