/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.blocks.compressed_air_engine;

import com.lgmrszd.compressedcreativity.blocks.compressed_air_engine.CompressedAirEngineBlockEntity;
import com.lgmrszd.compressedcreativity.index.CCBlockPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CompressedAirEngineVisual
extends KineticBlockEntityVisual<CompressedAirEngineBlockEntity> {
    protected final RotatingInstance shaft;
    protected final RotatingInstance rotor;
    final Direction direction;

    public CompressedAirEngineVisual(VisualizationContext context, CompressedAirEngineBlockEntity tile, float partialTick) {
        super(context, (KineticBlockEntity)tile, partialTick);
        this.direction = ((Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_();
        this.shaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT, (Direction)this.direction)).createInstance();
        this.rotor = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)CCBlockPartials.AIR_ENGINE_ROTOR)).createInstance();
        this.shaft.setup((KineticBlockEntity)tile).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.UP, this.direction.m_122434_()).setChanged();
        this.rotor.setup((KineticBlockEntity)tile).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, this.direction).setChanged();
    }

    public void update(float partialTick) {
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        this.rotor.setup((KineticBlockEntity)this.blockEntity).setChanged();
    }

    public void updateLight(float partialTick) {
        this.relight(this.pos, new FlatLit[]{this.shaft});
        this.relight(this.pos, new FlatLit[]{this.rotor});
    }

    public void _delete() {
        this.shaft.delete();
        this.rotor.delete();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.shaft);
        consumer.accept((Instance)this.rotor);
    }
}

