/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.blocks.bracketed_pressure_tube;

import com.lgmrszd.compressedcreativity.blocks.bracketed_pressure_tube.BracketedPressureTubeBlockEntity;
import com.lgmrszd.compressedcreativity.index.CCBlockEntities;
import com.lgmrszd.compressedcreativity.index.CCMisc;
import com.lgmrszd.compressedcreativity.index.CCModsReference;
import com.simibubi.create.AllShapes;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.decoration.bracket.BracketBlockItem;
import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.equipment.wrench.IWrenchableWithBracket;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Optional;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.ITubeNetworkConnector;
import me.desht.pneumaticcraft.api.block.PNCBlockStateProperties;
import me.desht.pneumaticcraft.api.block.PressureTubeConnection;
import me.desht.pneumaticcraft.api.misc.IMiscHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BracketedPressureTubeBlock
extends RotatedPillarBlock
implements IBE<BracketedPressureTubeBlockEntity>,
IWrenchableWithBracket,
SimpleWaterloggedBlock,
SpecialBlockItemRequirement,
ITubeNetworkConnector {
    private final int tubeTier;

    public BracketedPressureTubeBlock(BlockBehaviour.Properties properties, int tier) {
        super(properties);
        this.tubeTier = tier;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> definition) {
        super.m_7926_(definition.m_61104_(new Property[]{BlockStateProperties.f_61362_}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.FOUR_VOXEL_POLE.get((Direction.Axis)state.m_61143_((Property)f_55923_));
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean blockTypeChanged;
        boolean bl = blockTypeChanged = state.m_60734_() != newState.m_60734_();
        if (state != newState && !isMoving) {
            this.removeBracket((BlockGetter)world, pos, true).ifPresent(stack -> Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack));
        }
        if (state.m_155947_() && (blockTypeChanged || !newState.m_155947_())) {
            world.m_46747_(pos);
        }
        IMiscHelpers miscHelpers = PneumaticRegistry.getInstance().getMiscHelpers();
        miscHelpers.forceClientShapeRecalculation(world, pos);
    }

    public boolean tryRemoveBracket(UseOnContext context) {
        boolean removed = super.tryRemoveBracket(context);
        if (removed) {
            BlockPos pos;
            Level world = context.m_43725_();
            BlockState oldBlockState = world.m_8055_(pos = context.m_8083_());
            CCModsReference.BracketedPressureTube bracketedPressureTube = CCModsReference.BracketedPressureTube.getByBlock(oldBlockState.m_60734_());
            if (bracketedPressureTube == null) {
                return true;
            }
            BlockState newBlockState = CCModsReference.PNCPressureTube.getByTier(bracketedPressureTube.getTier()).getBlock().m_49966_();
            newBlockState = (BlockState)newBlockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)oldBlockState.m_61143_((Property)BlockStateProperties.f_61362_)));
            switch ((Direction.Axis)oldBlockState.m_61143_((Property)f_55923_)) {
                case X: {
                    newBlockState = (BlockState)((BlockState)newBlockState.m_61124_((Property)PNCBlockStateProperties.PressureTubes.WEST, (Comparable)PressureTubeConnection.CONNECTED)).m_61124_((Property)PNCBlockStateProperties.PressureTubes.EAST, (Comparable)PressureTubeConnection.CONNECTED);
                    break;
                }
                case Y: {
                    newBlockState = (BlockState)((BlockState)newBlockState.m_61124_((Property)PNCBlockStateProperties.PressureTubes.UP, (Comparable)PressureTubeConnection.CONNECTED)).m_61124_((Property)PNCBlockStateProperties.PressureTubes.DOWN, (Comparable)PressureTubeConnection.CONNECTED);
                    break;
                }
                case Z: {
                    newBlockState = (BlockState)((BlockState)newBlockState.m_61124_((Property)PNCBlockStateProperties.PressureTubes.NORTH, (Comparable)PressureTubeConnection.CONNECTED)).m_61124_((Property)PNCBlockStateProperties.PressureTubes.SOUTH, (Comparable)PressureTubeConnection.CONNECTED);
                }
            }
            CCMisc.setBlockAndUpdateKeepAir(world, context.m_8083_(), newBlockState);
            IMiscHelpers miscHelpers = PneumaticRegistry.getInstance().getMiscHelpers();
            miscHelpers.forceClientShapeRecalculation(context.m_43725_(), context.m_8083_());
        }
        return removed;
    }

    public Optional<ItemStack> removeBracket(BlockGetter world, BlockPos pos, boolean inOnReplacedContext) {
        BracketedBlockEntityBehaviour behaviour = (BracketedBlockEntityBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos, (BehaviourType)BracketedBlockEntityBehaviour.TYPE);
        if (behaviour == null) {
            return Optional.empty();
        }
        BlockState bracket = behaviour.removeBracket(inOnReplacedContext);
        if (bracket == null) {
            return Optional.empty();
        }
        return Optional.of(new ItemStack((ItemLike)bracket.m_60734_()));
    }

    public Class<BracketedPressureTubeBlockEntity> getBlockEntityClass() {
        return BracketedPressureTubeBlockEntity.class;
    }

    public BlockEntityType<? extends BracketedPressureTubeBlockEntity> getBlockEntityType() {
        if (this.tubeTier == 1) {
            return (BlockEntityType)CCBlockEntities.BRACKETED_REINFORCED_PRESSURE_TUBE.get();
        }
        if (this.tubeTier == 2) {
            return (BlockEntityType)CCBlockEntities.BRACKETED_ADVANCED_PRESSURE_TUBE.get();
        }
        return (BlockEntityType)CCBlockEntities.BRACKETED_PRESSURE_TUBE.get();
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        CCModsReference.BracketedPressureTube bracketedPressureTube = CCModsReference.BracketedPressureTube.getByBlock(state.m_60734_());
        if (bracketedPressureTube == null) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        return new ItemStack((ItemLike)CCModsReference.PNCPressureTube.getByTier(bracketedPressureTube.getTier()).getBlock());
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity te) {
        CCModsReference.BracketedPressureTube bracketedPressureTube = CCModsReference.BracketedPressureTube.getByBlock(state.m_60734_());
        if (bracketedPressureTube == null) {
            return ItemRequirement.INVALID;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, List.of(new ItemStack((ItemLike)CCModsReference.PNCPressureTube.getByTier(bracketedPressureTube.getTier()).getBlock())));
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        BlockEntity blockEntity;
        super.onNeighborChange(state, level, pos, neighbor);
        BlockEntity blockEntity2 = blockEntity = state.m_155947_() ? level.m_7702_(pos) : null;
        if (blockEntity instanceof BracketedPressureTubeBlockEntity) {
            BracketedPressureTubeBlockEntity tte = (BracketedPressureTubeBlockEntity)blockEntity;
            tte.updateAirHandler();
        }
    }

    public boolean canConnectToNetwork(Level level, BlockPos pos, Direction dir, BlockState state) {
        return state.m_61138_((Property)f_55923_) && dir.m_122434_() == state.m_61143_((Property)f_55923_);
    }

    @SubscribeEvent
    public static void usingBracketOnPressureTube(PlayerInteractEvent.RightClickBlock event) {
        ItemStack item = event.getItemStack();
        Level world = event.getLevel();
        BlockPos blockPos = event.getPos();
        BlockState blockState = world.m_8055_(blockPos);
        if (!(item.m_41720_() instanceof BracketBlockItem)) {
            return;
        }
        CCModsReference.PNCPressureTube pressureTube = CCModsReference.PNCPressureTube.getByBlock(blockState.m_60734_());
        if (pressureTube == null) {
            return;
        }
        BlockState axisTubeState = CCModsReference.BracketedPressureTube.getByTier(pressureTube.getTier()).getBlock().m_49966_();
        boolean c_down = blockState.m_61143_((Property)PNCBlockStateProperties.PressureTubes.DOWN) == PressureTubeConnection.CONNECTED;
        boolean c_up = blockState.m_61143_((Property)PNCBlockStateProperties.PressureTubes.UP) == PressureTubeConnection.CONNECTED;
        boolean c_north = blockState.m_61143_((Property)PNCBlockStateProperties.PressureTubes.NORTH) == PressureTubeConnection.CONNECTED;
        boolean c_south = blockState.m_61143_((Property)PNCBlockStateProperties.PressureTubes.SOUTH) == PressureTubeConnection.CONNECTED;
        boolean c_west = blockState.m_61143_((Property)PNCBlockStateProperties.PressureTubes.WEST) == PressureTubeConnection.CONNECTED;
        boolean c_east = blockState.m_61143_((Property)PNCBlockStateProperties.PressureTubes.EAST) == PressureTubeConnection.CONNECTED;
        Direction.Axis axis = null;
        if (!c_down && !c_up && !c_north && !c_south && c_east && c_west) {
            axis = Direction.Axis.X;
        }
        if (c_down && c_up && !c_north && !c_south && !c_east && !c_west) {
            axis = Direction.Axis.Y;
        }
        if (!c_down && !c_up && c_north && c_south && !c_east && !c_west) {
            axis = Direction.Axis.Z;
        }
        if (axis != null) {
            BlockState newState = (BlockState)((BlockState)axisTubeState.m_61124_((Property)f_55923_, axis)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)));
            CCMisc.setBlockAndUpdateKeepAir(world, blockPos, newState);
        }
    }
}

