/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.blocks.advanced_air_blower;

import com.lgmrszd.compressedcreativity.CompressedCreativity;
import com.lgmrszd.compressedcreativity.blocks.ITintedBlockEntity;
import com.lgmrszd.compressedcreativity.blocks.air_blower.AirBlowerBlock;
import com.lgmrszd.compressedcreativity.blocks.air_blower.AirBlowerBlockEntity;
import com.lgmrszd.compressedcreativity.config.CommonConfig;
import com.lgmrszd.compressedcreativity.config.PressureTierConfig;
import com.lgmrszd.compressedcreativity.content.Mesh;
import com.lgmrszd.compressedcreativity.index.CCItems;
import com.lgmrszd.compressedcreativity.index.CCLang;
import com.lgmrszd.compressedcreativity.items.MeshItem;
import com.lgmrszd.compressedcreativity.network.ForceUpdatePacket;
import com.lgmrszd.compressedcreativity.network.IUpdateBlockEntity;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class AdvancedAirBlowerBlockEntity
extends AirBlowerBlockEntity
implements IUpdateBlockEntity,
ITintedBlockEntity {
    private ItemStack mesh;
    private final IHeatExchangerLogic airExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    protected final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);
    private double ambientTemp;
    private float coolingStatus = 0.0f;

    public AdvancedAirBlowerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, PressureTierConfig.CustomTier.INDUSTRIAL_AIR_BLOWER_TIER, (Integer)CommonConfig.INDUSTRIAL_AIR_BLOWER_VOLUME.get());
        this.heatExchanger.setThermalCapacity(5.0);
        this.airExchanger.addConnectedExchanger(this.heatExchanger);
        this.airExchanger.setThermalResistance(25.0);
        this.mesh = ItemStack.f_41583_;
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToTooltip(tooltip, isPlayerSneaking);
        if (!this.mesh.m_41619_()) {
            if (this.mesh.m_41720_() instanceof MeshItem) {
                CCLang.translate("tooltip.installed_mesh", new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
                CCLang.builder().add(CreateLang.itemName((ItemStack)this.mesh)).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
            }
        } else {
            CCLang.translate("tooltip.installed_mesh_none", new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        }
        return true;
    }

    @Override
    public int getTintColor(int tintIndex) {
        if (tintIndex == 0) {
            return HeatUtil.getColourForTemperature((int)this.heatExchanger.getTemperatureAsInt()).getRGB();
        }
        return HeatUtil.getColourForTemperature((int)300).getRGB();
    }

    protected ItemStack getMesh() {
        return this.mesh.m_41777_();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateHeatExchanger();
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.ambientTemp = HeatExchangerLogicAmbient.getAmbientTemperature((LevelAccessor)this.m_58904_(), (BlockPos)this.m_58899_());
            this.airExchanger.setTemperature(this.ambientTemp);
        }
    }

    public Mesh.IMeshType getMeshType() {
        Mesh.IMeshType iMeshType;
        Item item = this.getMesh().m_41720_();
        if (item instanceof MeshItem) {
            MeshItem meshItem = (MeshItem)item;
            iMeshType = meshItem.getMeshType();
        } else {
            iMeshType = null;
        }
        return iMeshType;
    }

    protected void setMesh(ItemStack stack) {
        this.mesh = stack.m_41777_();
        this.mesh.m_41764_(1);
        this.m_6596_();
        this.sendData();
    }

    public Optional<FanProcessingType> getProcessingType() {
        MeshItem meshItem;
        Optional<FanProcessingType> processingType;
        Item item = this.getMesh().m_41720_();
        if (item instanceof MeshItem && (processingType = (meshItem = (MeshItem)item).getMeshType().getProcessingType(this.heatExchanger.getTemperatureAsInt())).isPresent()) {
            return processingType;
        }
        if (this.heatExchanger.getTemperatureAsInt() > 573) {
            return Optional.of(AllFanProcessingTypes.BLASTING);
        }
        if (this.heatExchanger.getTemperatureAsInt() > 373) {
            return Optional.of(AllFanProcessingTypes.SMOKING);
        }
        return Optional.empty();
    }

    @Override
    protected float calculateAirUsage() {
        return Math.max(1.0f, (float)Math.floor(this.airHandler.getPressure() * ((Double)CommonConfig.AIR_BLOWER_AIR_USAGE_PER_BAR.get()).floatValue() * 150.0f) / 100.0f);
    }

    @Override
    protected float calculateProcessingSpeed() {
        float pressure = this.airHandler.getPressure();
        if (pressure < 1.0f) {
            float x = pressure - 1.0f;
            return 1.0f - x * x * x * x;
        }
        if (pressure < 9.0f) {
            float x = (pressure - 1.0f) / 8.5f;
            return 1.0f + x * x * 3.0f;
        }
        return 4.0f;
    }

    public void updateHeatExchanger() {
        ArrayList<Direction> sides = new ArrayList<Direction>();
        for (Direction side : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP, Direction.DOWN}) {
            if (!this.canConnectPneumatic(side)) continue;
            sides.add(side);
        }
        Direction[] sides_2 = new Direction[sides.size()];
        this.heatExchanger.initializeAsHull(this.m_58904_(), this.m_58899_(), (levelAccessor, blockPos) -> true, sides.toArray(sides_2));
        CompressedCreativity.LOGGER.debug("Updated Heat Exchanger! Side: " + this.m_58900_().m_61143_(AirBlowerBlock.FACING));
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.HEAT_EXCHANGER_CAPABILITY && this.canConnectPneumatic(side)) {
            return this.heatCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void tick() {
        super.tick();
        boolean server = this.f_58857_ != null && !this.f_58857_.m_5776_();
        int oldTemp = this.heatExchanger.getTemperatureAsInt();
        this.heatExchanger.tick();
        if (server) {
            int diff = Math.abs(this.heatExchanger.getTemperatureAsInt() - oldTemp);
            if (diff > 2) {
                this.updateTintServer();
                this.m_6596_();
                this.sendData();
            }
            this.airExchanger.tick();
            if (this.airHandler.getPressure() > 0.0f && this.airCurrent.maxDistance > 0.0f) {
                this.coolingStatus += this.calculateCoolingSpeed();
                if (Math.floor(this.coolingStatus) > 1.0) {
                    int cooling_ticks;
                    for (int i = cooling_ticks = (int)Math.floor(this.coolingStatus); i > 0; --i) {
                        this.heatExchanger.tick();
                        this.airExchanger.setTemperature(this.ambientTemp);
                    }
                    this.coolingStatus -= (float)cooling_ticks;
                }
            }
        }
    }

    private float calculateCoolingSpeed() {
        Mesh.IMeshType meshType = this.getMeshType();
        if (meshType == null) {
            return this.calculateProcessingSpeed();
        }
        return this.calculateProcessingSpeed() * (float)meshType.getCoolingFactor();
    }

    public void lazyTick() {
        MeshItem meshItem;
        super.lazyTick();
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.updateTintClient();
            return;
        }
        Item item = this.mesh.m_41720_();
        if (item instanceof MeshItem && (meshItem = (MeshItem)item).getMeshType() == Mesh.MeshType.SPLASHING) {
            if (this.heatExchanger.getTemperatureAsInt() < 268) {
                this.setMesh(new ItemStack((ItemLike)CCItems.MESHES.get(Mesh.MeshType.SPLASHING_FROZEN.getName()).get()));
            }
            if (this.heatExchanger.getTemperatureAsInt() > 378) {
                this.setMesh(new ItemStack((ItemLike)CCItems.MESHES.get(Mesh.MeshType.WOVEN.getName()).get()));
            }
        } else {
            MeshItem meshItem2;
            item = this.mesh.m_41720_();
            if (item instanceof MeshItem && (meshItem2 = (MeshItem)item).getMeshType() == Mesh.MeshType.SPLASHING_FROZEN && this.heatExchanger.getTemperatureAsInt() > 278) {
                this.setMesh(new ItemStack((ItemLike)CCItems.MESHES.get(Mesh.MeshType.SPLASHING.getName()).get()));
            }
        }
        this.sendData();
    }

    public void updateTintClient() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 0);
        }
    }

    public void updateTintServer() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            ForceUpdatePacket.send(this.f_58857_, this.m_58899_());
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.heatCap.invalidate();
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("mesh", (Tag)this.getMesh().serializeNBT());
        compound.m_128365_("HeatExchanger", (Tag)this.heatExchanger.serializeNBT());
        compound.m_128365_("airExchanger", (Tag)this.airExchanger.serializeNBT());
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.mesh = ItemStack.m_41712_((CompoundTag)compound.m_128469_("mesh"));
        this.heatExchanger.deserializeNBT(compound.m_128469_("HeatExchanger"));
        this.airExchanger.deserializeNBT(compound.m_128469_("airExchanger"));
        super.read(compound, clientPacket);
    }

    @Override
    public void forceUpdate() {
        this.updateTintClient();
    }

    @Override
    public float getMaxDistance() {
        float pressure = this.airHandler.getPressure();
        if (pressure > 7.0f) {
            return Mth.m_14179_((float)((pressure - 7.0f) / 3.0f), (float)1.0f, (float)2.5f);
        }
        return 1.0f;
    }
}

