/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.aspect;

import lombok.NonNull;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectVariable;

public abstract class UpdatingAspectVariable<V extends IValue>
implements IAspectVariable<V> {
    private final IValueType<V> type;
    private final PartTarget target;
    @NonNull
    private V value;

    public UpdatingAspectVariable(IValueType<V> type, PartTarget target) {
        this.type = type;
        this.target = target;
        this.value = type.getDefault();
    }

    @Override
    public IValueType<V> getType() {
        return this.type;
    }

    @Override
    public PartTarget getTarget() {
        return this.target;
    }

    @Override
    @NonNull
    public V getValue() {
        return this.value;
    }

    public void setValue(@NonNull V value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdatingAspectVariable)) {
            return false;
        }
        UpdatingAspectVariable other = (UpdatingAspectVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IValueType<V> this$type = this.getType();
        IValueType<V> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        PartTarget this$target = this.getTarget();
        PartTarget other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        V this$value = this.getValue();
        V other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdatingAspectVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IValueType<V> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        PartTarget $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        V $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "UpdatingAspectVariable(type=" + String.valueOf(this.getType()) + ", target=" + String.valueOf(this.getTarget()) + ", value=" + String.valueOf(this.getValue()) + ")";
    }
}

