/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.ingredient;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegisterEvent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandlerRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlerRegistry;

public class IngredientComponentHandlers {
    public static final IIngredientComponentHandlerRegistry REGISTRY = IngredientComponentHandlers.constructRegistry();

    private static IIngredientComponentHandlerRegistry constructRegistry() {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return (IIngredientComponentHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IIngredientComponentHandlerRegistry.class);
        }
        return IngredientComponentHandlerRegistry.getInstance();
    }

    public static void load() {
    }

    public static void onIngredientComponentsPopulated(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)IngredientComponent.REGISTRY.getRegistryKey())) {
            final IngredientComponent componentItem = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation("minecraft:itemstack"));
            final IngredientComponent componentFluid = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation("minecraft:fluidstack"));
            final IngredientComponent componentEnergy = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation("minecraft:energy"));
            REGISTRY.register(new IIngredientComponentHandler<ValueObjectTypeItemStack, ValueObjectTypeItemStack.ValueItemStack, ItemStack, Integer>(){

                @Override
                public ValueObjectTypeItemStack getValueType() {
                    return ValueTypes.OBJECT_ITEMSTACK;
                }

                @Override
                public IngredientComponent<ItemStack, Integer> getComponent() {
                    return componentItem;
                }

                @Override
                public ValueObjectTypeItemStack.ValueItemStack toValue(ItemStack instance) {
                    return ValueObjectTypeItemStack.ValueItemStack.of(instance);
                }

                @Override
                public ItemStack toInstance(ValueObjectTypeItemStack.ValueItemStack value) {
                    return value.getRawValue();
                }
            });
            REGISTRY.register(new IIngredientComponentHandler<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack, FluidStack, Integer>(){

                @Override
                public ValueObjectTypeFluidStack getValueType() {
                    return ValueTypes.OBJECT_FLUIDSTACK;
                }

                @Override
                public IngredientComponent<FluidStack, Integer> getComponent() {
                    return componentFluid;
                }

                @Override
                public ValueObjectTypeFluidStack.ValueFluidStack toValue(@Nullable FluidStack instance) {
                    return ValueObjectTypeFluidStack.ValueFluidStack.of(instance);
                }

                @Override
                @Nullable
                public FluidStack toInstance(ValueObjectTypeFluidStack.ValueFluidStack value) {
                    return value.getRawValue();
                }
            });
            REGISTRY.register(new IIngredientComponentHandler<ValueTypeLong, ValueTypeLong.ValueLong, Long, Boolean>(){

                @Override
                public ValueTypeLong getValueType() {
                    return ValueTypes.LONG;
                }

                @Override
                public IngredientComponent<Long, Boolean> getComponent() {
                    return componentEnergy;
                }

                @Override
                public ValueTypeLong.ValueLong toValue(@Nullable Long instance) {
                    return ValueTypeLong.ValueLong.of(instance);
                }

                @Override
                @Nullable
                public Long toInstance(ValueTypeLong.ValueLong value) {
                    return value.getRawValue();
                }

                @Override
                public Component toCompactString(ValueTypeLong.ValueLong ingredientValue) {
                    return this.getValueType().toCompactString(ingredientValue).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"general.integrateddynamics.energy_unit"));
                }
            });
        }
    }
}

