/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.util.ClientUtils;

public class BlockEntityAnimDataSyncPacket<D> {
    private final BlockPos pos;
    private final SerializableDataTicket<D> dataTicket;
    private final D data;

    public BlockEntityAnimDataSyncPacket(BlockPos pos, SerializableDataTicket<D> dataTicket, D data) {
        this.pos = pos;
        this.dataTicket = dataTicket;
        this.data = data;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130070_(this.dataTicket.id());
        this.dataTicket.encode(this.data, buffer);
    }

    public static <D> BlockEntityAnimDataSyncPacket<D> decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        SerializableDataTicket<?> dataTicket = DataTickets.byName(buffer.m_130277_());
        return new BlockEntityAnimDataSyncPacket(pos, dataTicket, dataTicket.decode(buffer));
    }

    public void receivePacket(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context handler = context.get();
        handler.enqueueWork(() -> {
            BlockEntity blockEntity = ClientUtils.getLevel().m_7702_(this.pos);
            if (blockEntity instanceof GeoBlockEntity) {
                GeoBlockEntity geoBlockEntity = (GeoBlockEntity)blockEntity;
                geoBlockEntity.setAnimData(this.dataTicket, this.data);
            }
        });
        handler.setPacketHandled(true);
    }
}

