/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.packingtape;

import gigaherz.packingtape.ConfigValues;
import gigaherz.packingtape.tape.PackagedBlock;
import gigaherz.packingtape.tape.PackagedBlockEntity;
import gigaherz.packingtape.tape.TapeItem;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="packingtape")
public class PackingTapeMod {
    public static final String MODID = "packingtape";
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"packingtape");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"packingtape");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"packingtape");
    public static final RegistryObject<PackagedBlock> PACKAGED_BLOCK = BLOCKS.register("packaged_block", () -> new PackagedBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283930_).m_60913_(0.5f, 0.5f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<BlockItem> PACKAGED_BLOCK_ITEM = ITEMS.register(PACKAGED_BLOCK.getId().m_135815_(), () -> new BlockItem((Block)PACKAGED_BLOCK.get(), new Item.Properties().m_41487_(16)));
    public static final RegistryObject<BlockEntityType<?>> PACKAGED_BLOCK_ENTITY = BLOCK_ENTITIES.register(PACKAGED_BLOCK.getId().m_135815_(), () -> BlockEntityType.Builder.m_155273_(PackagedBlockEntity::new, (Block[])new Block[]{(Block)PACKAGED_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<TapeItem> TAPE = ITEMS.register("tape", () -> new TapeItem(new Item.Properties().m_41487_(16)));

    public PackingTapeMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        modEventBus.addListener(this::serverConfig);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::addItemsToTabs);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigValues.SERVER_SPEC);
    }

    private void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(TAPE);
            event.accept(PACKAGED_BLOCK_ITEM, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGen.gatherData(event);
    }

    public void serverConfig(ModConfigEvent event) {
        if (event.getConfig().getSpec() == ConfigValues.SERVER_SPEC) {
            ConfigValues.bake();
        }
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static class DataGen {
        public static void gatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            gen.addProvider(event.includeServer(), (DataProvider)Loot.create(gen.getPackOutput()));
            gen.addProvider(event.includeServer(), (DataProvider)new Recipes(gen));
        }

        private static class Loot {
            private Loot() {
            }

            public static LootTableProvider create(PackOutput gen) {
                return new LootTableProvider(gen, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockTables::new, LootContextParamSets.f_81421_)));
            }

            public static class BlockTables
            extends BlockLootSubProvider {
                public BlockTables() {
                    super(Set.of(), FeatureFlags.f_244280_.m_247355_());
                }

                protected void m_245660_() {
                    this.m_246481_((Block)PACKAGED_BLOCK.get(), this::dropWithPackagedContents);
                }

                protected LootTable.Builder dropWithPackagedContents(Block p_218544_0_) {
                    return LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)p_218544_0_, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_218544_0_).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Block", "BlockEntityTag.Block").m_80279_("BlockEntity", "BlockEntityTag.BlockEntity").m_80279_("PreferredDirection", "BlockEntityTag.PreferredDirection")))));
                }

                protected Iterable<Block> getKnownBlocks() {
                    return ForgeRegistries.BLOCKS.getEntries().stream().filter(e -> ((ResourceKey)e.getKey()).m_135782_().m_135827_().equals(PackingTapeMod.MODID)).map(Map.Entry::getValue).collect(Collectors.toList());
                }
            }
        }

        private static class Recipes
        extends RecipeProvider
        implements DataProvider,
        IConditionBuilder {
            public Recipes(DataGenerator gen) {
                super(gen.getPackOutput());
            }

            protected void m_245200_(Consumer<FinishedRecipe> consumer) {
                ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TAPE.get())).m_126209_((ItemLike)Items.f_42518_).m_126209_((ItemLike)Items.f_42401_).m_126209_((ItemLike)Items.f_42516_).m_126132_("has_slime_ball", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42518_)).m_176498_(consumer);
            }
        }
    }
}

