/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.network;

import io.redspace.pvp_flagging.client.ClientHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundPvpFlagUpdate {
    private final boolean flagged;
    private final UUID playerUUID;

    public ClientboundPvpFlagUpdate(UUID playerUUID, boolean flagged) {
        this.flagged = flagged;
        this.playerUUID = playerUUID;
    }

    public ClientboundPvpFlagUpdate(FriendlyByteBuf buf) {
        this.flagged = buf.readBoolean();
        this.playerUUID = buf.m_130259_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.flagged);
        buf.m_130077_(this.playerUUID);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ClientHelper.handlePvpFlagUpdate(this.playerUUID, this.flagged));
    }
}

