/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.events;

import io.redspace.pvp_flagging.config.PvpConfig;
import io.redspace.pvp_flagging.config.PvpConfigState;
import io.redspace.pvp_flagging.core.PlayerFlagManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pvp_flagging", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEventsForge {
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (PlayerFlagManager.INSTANCE != null) {
                PlayerFlagManager.INSTANCE.syncToPlayer(serverPlayer);
                switch ((PvpConfigState)((Object)PvpConfig.SERVER.PLAYER_LOGIN_STATE.get())) {
                    case FLAG: {
                        PlayerFlagManager.INSTANCE.flagPlayer(serverPlayer);
                        break;
                    }
                    case UNFLAG: {
                        PlayerFlagManager.INSTANCE.unflagPlayerImmediate(serverPlayer);
                    }
                }
                PlayerFlagManager.INSTANCE.syncToPlayer(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (PlayerFlagManager.INSTANCE != null) {
                PlayerFlagManager.INSTANCE.cancelScheduledUnflag(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (PlayerFlagManager.INSTANCE != null) {
                switch ((PvpConfigState)((Object)PvpConfig.SERVER.PLAYER_RESPAWN_STATE.get())) {
                    case FLAG: {
                        PlayerFlagManager.INSTANCE.flagPlayer(serverPlayer);
                        break;
                    }
                    case UNFLAG: {
                        PlayerFlagManager.INSTANCE.unflagPlayerImmediate(serverPlayer);
                    }
                }
                PlayerFlagManager.INSTANCE.syncToPlayer(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        boolean pvp;
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        boolean bl = pvp = victim instanceof ServerPlayer && attacker instanceof ServerPlayer;
        if (pvp && PlayerFlagManager.INSTANCE.anyPlayersScheduledToUnflag()) {
            PlayerFlagManager.INSTANCE.cancelScheduledUnflag((ServerPlayer)victim);
            PlayerFlagManager.INSTANCE.cancelScheduledUnflag((ServerPlayer)attacker);
        }
    }
}

