/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.core;

import io.redspace.pvp_flagging.config.PvpConfig;
import io.redspace.pvp_flagging.core.PlayerFlagManager;
import io.redspace.pvp_flagging.core.PvpZone;
import io.redspace.pvp_flagging.data.PvpDataStorage;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pvp_flagging", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PvpZoneManager
implements INBTSerializable<CompoundTag> {
    public static PvpZoneManager INSTANCE;
    private final ArrayList<PvpZone> pvpZones = new ArrayList();
    private int boundsCheckTicks = 0;

    public static void init() {
        INSTANCE = new PvpZoneManager();
    }

    public boolean addZone(PvpZone pvpZone) {
        if (!this.pvpZones.contains(pvpZone)) {
            this.pvpZones.add(pvpZone);
            PvpDataStorage.INSTANCE.m_77762_();
            return true;
        }
        return false;
    }

    public boolean boundsCheckShouldWarn(Player player) {
        for (int i = 0; i < this.pvpZones.size(); ++i) {
            PvpZone zone = this.pvpZones.get(i);
            if (!zone.getBufferedZoneBounds().contains(player.m_20182_())) continue;
            return true;
        }
        return false;
    }

    public boolean boundsCheckShouldFlag(Player player) {
        for (int i = 0; i < this.pvpZones.size(); ++i) {
            PvpZone zone = this.pvpZones.get(i);
            if (!zone.contains(player.m_20182_())) continue;
            return true;
        }
        return false;
    }

    public int boundsCheckTicks() {
        if (this.boundsCheckTicks == 0) {
            this.boundsCheckTicks = (Integer)PvpConfig.SERVER.PVP_ZONE_BOUNDS_CHECK_TICKS.get();
        }
        return this.boundsCheckTicks;
    }

    public void removeZone(String name) {
        this.pvpZones.stream().filter(zone -> zone.getName().equals(name)).findFirst().ifPresent(zone -> this.pvpZones.remove(zone));
        PvpDataStorage.INSTANCE.m_77762_();
    }

    public ArrayList<PvpZone> getZones() {
        return this.pvpZones;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag pvpZonesTag = new ListTag();
        for (PvpZone pvpZone : this.pvpZones) {
            pvpZonesTag.add((Object)pvpZone.serializeNBT());
        }
        tag.m_128365_("pvpZones", (Tag)pvpZonesTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("pvpZones")) {
            ListTag pvpZonesTag = nbt.m_128437_("pvpZones", 10);
            pvpZonesTag.forEach(pvpZoneTag -> this.pvpZones.add(PvpZone.getPvpZone((CompoundTag)pvpZoneTag)));
        }
    }

    public static void onServerTick(TickEvent.ServerTickEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        MinecraftServer server;
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END && !INSTANCE.getZones().isEmpty() && (server = (player = event.player).m_20194_()) != null && server.m_129783_().m_46467_() % (long)INSTANCE.boundsCheckTicks() == 0L) {
            if (!PlayerFlagManager.INSTANCE.isPlayerFlagged(player) && INSTANCE.boundsCheckShouldFlag(player)) {
                PlayerFlagManager.INSTANCE.flagPlayer((ServerPlayer)player);
            } else if (INSTANCE.boundsCheckShouldWarn(player)) {
                PlayerFlagManager.INSTANCE.warnPlayer((ServerPlayer)player);
            }
        }
    }
}

