/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.core;

import io.redspace.pvp_flagging.core.ZoneBounds;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class PvpZone
implements INBTSerializable<CompoundTag> {
    private String name;
    private int buffer;
    private ZoneBounds zoneBounds;
    private ZoneBounds bufferedZoneBounds = null;

    private PvpZone() {
    }

    public PvpZone(@NotNull String name, int x1, int z1, int x2, int z2, int buffer) {
        this.zoneBounds = new ZoneBounds(x1, z1, x2, z2);
        this.name = Objects.requireNonNull(name);
        this.buffer = buffer;
    }

    public ZoneBounds getBufferedZoneBounds() {
        if (this.bufferedZoneBounds == null) {
            this.bufferedZoneBounds = this.zoneBounds.inflate(this.buffer);
        }
        return this.bufferedZoneBounds;
    }

    public ZoneBounds getBounds() {
        return this.zoneBounds;
    }

    public String getName() {
        return this.name;
    }

    boolean contains(Vec3 pos) {
        return this.zoneBounds.contains(pos.f_82479_, pos.f_82481_);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PvpZone)) return false;
        PvpZone pvpZone = (PvpZone)obj;
        if (this.name == null) return false;
        if (!this.name.equals(pvpZone.name)) return false;
        return true;
    }

    public String toString() {
        return String.format("Name:%s, Buffer:%d, %s", this.name, this.buffer, this.zoneBounds);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", this.name);
        tag.m_128405_("buffer", this.buffer);
        tag.m_128365_("zoneBounds", (Tag)this.zoneBounds.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.name = nbt.m_128461_("name");
        this.buffer = nbt.m_128451_("buffer");
        this.zoneBounds = ZoneBounds.getZoneBounds(nbt.m_128469_("zoneBounds"));
    }

    public static PvpZone getPvpZone(CompoundTag nbt) {
        PvpZone pvpZone = new PvpZone();
        pvpZone.deserializeNBT(nbt);
        return pvpZone;
    }
}

