/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.core;

import io.redspace.pvp_flagging.PvpFlagging;
import io.redspace.pvp_flagging.config.PvpConfig;
import io.redspace.pvp_flagging.data.PvpDataStorage;
import io.redspace.pvp_flagging.network.ClientboundPvpFlagUpdate;
import io.redspace.pvp_flagging.network.ClientboundPvpWarnPlayer;
import io.redspace.pvp_flagging.network.ClientboundSyncPvpData;
import io.redspace.pvp_flagging.network.ClientbountPvpCancelScheduledUnflag;
import io.redspace.pvp_flagging.network.ClientbountPvpUnflagScheduled;
import io.redspace.pvp_flagging.registries.Network;
import io.redspace.pvp_flagging.util.Logging;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="pvp_flagging", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerFlagManager
implements INBTSerializable<CompoundTag> {
    public static PlayerFlagManager INSTANCE;
    private final int EXPECTED_SIZE = 20;
    private final ObjectSet<UUID> flaggedPlayers = new ObjectOpenHashSet(20);
    private final Int2ObjectMap<ScheduleUnflagItem> playersScheduledToUnflag = new Int2ObjectOpenHashMap(20);

    public static void init() {
        INSTANCE = new PlayerFlagManager();
    }

    public boolean isPlayerFlagged(@Nullable Player player) {
        return player != null && this.flaggedPlayers.contains((Object)player.m_20148_());
    }

    public boolean anyPlayersScheduledToUnflag() {
        return !this.playersScheduledToUnflag.isEmpty();
    }

    public boolean isScheduledToUnflag(ServerPlayer player) {
        return this.playersScheduledToUnflag.containsKey(player.m_19879_());
    }

    public boolean areBothPlayersFlagged(Player player1, Player player2) {
        return this.flaggedPlayers.contains((Object)player1.m_20148_()) && this.flaggedPlayers.contains((Object)player2.m_20148_());
    }

    public void flagPlayer(@Nullable ServerPlayer serverPlayer) {
        if (Logging.PLAYER_FLAG_MANAGER) {
            PvpFlagging.LOGGER.debug("PlayerFlagManger flagPlayer:{}", (Object)serverPlayer);
        }
        if (serverPlayer != null) {
            this.cancelScheduledUnflag(serverPlayer);
            this.flaggedPlayers.add((Object)serverPlayer.m_20148_());
            PvpDataStorage.INSTANCE.m_77762_();
            Network.sendToAllPlayers(new ClientboundPvpFlagUpdate(serverPlayer.m_20148_(), true));
        }
    }

    public void warnPlayer(@Nullable ServerPlayer serverPlayer) {
        if (Logging.PLAYER_FLAG_MANAGER) {
            PvpFlagging.LOGGER.debug("PlayerFlagManger warnPlayer:{}", (Object)serverPlayer);
        }
        if (serverPlayer != null) {
            Network.sendToPlayer(new ClientboundPvpWarnPlayer(), serverPlayer);
        }
    }

    public void cancelScheduledUnflag(@Nullable ServerPlayer serverPlayer) {
        if (serverPlayer != null && !this.playersScheduledToUnflag.isEmpty() && this.playersScheduledToUnflag.remove(serverPlayer.m_19879_()) != null) {
            if (Logging.PLAYER_FLAG_MANAGER) {
                PvpFlagging.LOGGER.debug("PlayerFlagManger cancelScheduledUnflag:{}", (Object)serverPlayer);
            }
            Network.sendToPlayer(new ClientbountPvpCancelScheduledUnflag(0), serverPlayer);
        }
    }

    public void unflagPlayerImmediate(@Nullable ServerPlayer serverPlayer) {
        if (Logging.PLAYER_FLAG_MANAGER) {
            PvpFlagging.LOGGER.debug("PlayerFlagManger unflagPlayerImmediate:{}", (Object)serverPlayer);
        }
        if (serverPlayer != null && this.flaggedPlayers.contains((Object)serverPlayer.m_20148_())) {
            this.flaggedPlayers.remove((Object)serverPlayer.m_20148_());
            PvpDataStorage.INSTANCE.m_77762_();
            Network.sendToAllPlayers(new ClientboundPvpFlagUpdate(serverPlayer.m_20148_(), false));
            if (!this.playersScheduledToUnflag.isEmpty()) {
                this.playersScheduledToUnflag.remove(serverPlayer.m_19879_());
            }
        }
    }

    public void unflagPlayer(@Nullable ServerPlayer serverPlayer) {
        if (Logging.PLAYER_FLAG_MANAGER) {
            PvpFlagging.LOGGER.debug("PlayerFlagManger unflagPlayer:{}", (Object)serverPlayer);
        }
        if (serverPlayer != null && this.flaggedPlayers.contains((Object)serverPlayer.m_20148_())) {
            if (Logging.PLAYER_FLAG_MANAGER) {
                PvpFlagging.LOGGER.debug("Player {} is scheduled to be unflagged", (Object)serverPlayer.m_20148_());
            }
            MinecraftServer server = serverPlayer.m_20194_();
            long scheduledTick = 0L;
            int waitTicks = 0;
            if (server != null) {
                waitTicks = (Integer)PvpConfig.SERVER.UNFLAG_WAIT_TIME_TICKS.get();
                scheduledTick = server.m_129783_().m_46467_() + (long)waitTicks;
            }
            this.playersScheduledToUnflag.put(serverPlayer.m_19879_(), (Object)new ScheduleUnflagItem(serverPlayer, scheduledTick));
            Network.sendToPlayer(new ClientbountPvpUnflagScheduled(waitTicks), serverPlayer);
        }
    }

    public void syncToPlayer(ServerPlayer serverPlayer) {
        if (Logging.PLAYER_FLAG_MANAGER) {
            PvpFlagging.LOGGER.debug("PlayerFlagManger syncToPlayer:{}, count:{}", (Object)serverPlayer, (Object)this.flaggedPlayers.size());
        }
        if (!this.flaggedPlayers.isEmpty()) {
            Network.sendToPlayer(new ClientboundSyncPvpData(this.flaggedPlayers), serverPlayer);
        }
    }

    public void processScheduledUnflags(long gameTime) {
        if (!this.playersScheduledToUnflag.isEmpty()) {
            this.playersScheduledToUnflag.values().stream().filter(unflagItem -> unflagItem.scheduledTick < gameTime).toList().forEach(unflagItem -> {
                this.playersScheduledToUnflag.remove(unflagItem.serverPlayer.m_19879_());
                if (this.flaggedPlayers.contains((Object)unflagItem.serverPlayer.m_20148_())) {
                    this.flaggedPlayers.remove((Object)unflagItem.serverPlayer.m_20148_());
                    PvpDataStorage.INSTANCE.m_77762_();
                    Network.sendToAllPlayers(new ClientboundPvpFlagUpdate(unflagItem.serverPlayer.m_20148_(), false));
                }
                if (Logging.PLAYER_FLAG_MANAGER) {
                    PvpFlagging.LOGGER.debug("PlayerFlagManger processScheduledUnflags unflagged:{} ", (Object)unflagItem.serverPlayer);
                }
            });
        }
    }

    @SubscribeEvent
    public static void handleServerTick(TickEvent.ServerTickEvent event) {
        long gameTime;
        if (event.phase == TickEvent.Phase.END && (gameTime = event.getServer().m_129783_().m_46467_()) % 20L == 0L) {
            INSTANCE.processScheduledUnflags(gameTime);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag uuids = new ListTag();
        for (UUID flaggedPlayer : this.flaggedPlayers) {
            uuids.add((Object)NbtUtils.m_129226_((UUID)flaggedPlayer));
        }
        tag.m_128365_("flaggedPlayers", (Tag)uuids);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("flaggedPlayers", 11);
        for (Tag uuidTag : list) {
            try {
                UUID uuid = NbtUtils.m_129233_((Tag)uuidTag);
                this.flaggedPlayers.add((Object)uuid);
            }
            catch (Exception exception) {}
        }
    }

    public static class ScheduleUnflagItem {
        private final ServerPlayer serverPlayer;
        private final long scheduledTick;

        public ScheduleUnflagItem(ServerPlayer serverPlayer, long scheduledTick) {
            this.serverPlayer = serverPlayer;
            this.scheduledTick = scheduledTick;
        }

        public int hashCode() {
            return this.serverPlayer.hashCode();
        }

        public boolean equals(Object obj) {
            return this.serverPlayer.equals(obj);
        }
    }
}

