/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.redspace.pvp_flagging.core.PlayerFlagManager;
import io.redspace.pvp_flagging.core.PvpZoneManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class PvpFlagCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pvpFlag").requires(p -> p.m_6761_(0))).executes(context -> PvpFlagCommand.toggleFlag((CommandSourceStack)context.getSource()))).then(Commands.m_82127_((String)"on").executes(context -> PvpFlagCommand.flag((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"off").executes(context -> PvpFlagCommand.unflag((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"status").executes(context -> PvpFlagCommand.status((CommandSourceStack)context.getSource()))));
    }

    private static int toggleFlag(CommandSourceStack source) {
        if (source.m_230896_() != null && PlayerFlagManager.INSTANCE.isPlayerFlagged((Player)source.m_230896_()) && !PlayerFlagManager.INSTANCE.isScheduledToUnflag(source.m_230896_())) {
            if (PvpZoneManager.INSTANCE.boundsCheckShouldFlag((Player)source.m_230896_())) {
                source.m_81352_((Component)Component.m_237115_((String)"ui.pvp_flagging.pvp_zone.prevent_unflag"));
            } else {
                PvpFlagCommand.unflag(source);
            }
        } else {
            PvpFlagCommand.flag(source);
        }
        return 1;
    }

    private static int unflag(CommandSourceStack source) {
        PlayerFlagManager.INSTANCE.unflagPlayer(source.m_230896_());
        return 1;
    }

    private static int flag(CommandSourceStack source) {
        PlayerFlagManager.INSTANCE.flagPlayer(source.m_230896_());
        return 1;
    }

    private static int status(CommandSourceStack source) {
        boolean isPlayerFlagged = PlayerFlagManager.INSTANCE.isPlayerFlagged((Player)source.m_230896_());
        source.m_288197_(() -> Component.m_237110_((String)"ui.pvp_flagging.pvp_status", (Object[])new Object[]{isPlayerFlagged}), true);
        return 1;
    }
}

