/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.client;

import io.redspace.pvp_flagging.PvpFlagging;
import io.redspace.pvp_flagging.util.Logging;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class ClientHelper {
    private static HashMap<UUID, Component> flaggedPlayerLookup = new HashMap();
    public static final Component nameTagIndicator = Component.m_237115_((String)"ui.pvp_flagging.name_tag_indicator");
    private static int unflagTimestamp = -1;

    @Nullable
    public static Component getNameTag(Player player) {
        Component newTag = null;
        if (flaggedPlayerLookup.containsKey(player.m_20148_()) && (newTag = flaggedPlayerLookup.get(player.m_20148_())) == null) {
            newTag = player.m_5446_().m_6881_().m_7220_(nameTagIndicator);
            flaggedPlayerLookup.put(player.m_20148_(), newTag);
        }
        return newTag;
    }

    public static boolean isFlagged(UUID uuid) {
        return flaggedPlayerLookup.containsKey(uuid);
    }

    public static boolean isFlagged(Player player) {
        return ClientHelper.isFlagged(player.m_20148_());
    }

    public static void handlePvpUnflagScheduled(int ticks) {
        if (Logging.CLIENT_PVP_FLAG_CACHE) {
            PvpFlagging.LOGGER.debug("handlePvpUnflagScheduled: ticks:{}", (Object)ticks);
        }
        if (ticks > 0) {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237110_((String)"ui.pvp_flagging.pvp_off_scheduled", (Object[])new Object[]{ticks / 20}).m_130940_(ChatFormatting.RED), false);
            if (Minecraft.m_91087_().f_91074_ != null) {
                unflagTimestamp = Minecraft.m_91087_().f_91074_.f_19797_ + ticks;
            }
        }
    }

    public static void handlePvpUnflagScheduleCancelled(int ticks) {
        if (Logging.CLIENT_PVP_FLAG_CACHE) {
            PvpFlagging.LOGGER.debug("handlePvpUnflagScheduleCancelled: ticks:{}", (Object)ticks);
        }
        Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)"ui.pvp_flagging.pvp_off_scheduled_cancelled").m_130940_(ChatFormatting.RED), false);
        unflagTimestamp = -1;
    }

    public static int getUnflagTimestamp() {
        return unflagTimestamp;
    }

    public static void resetUnflagTimestamp() {
        unflagTimestamp = -1;
    }

    public static void handlePvpZoneWarning() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (Logging.CLIENT_PVP_FLAG_CACHE) {
            PvpFlagging.LOGGER.debug("handlePvpZoneWarning player:{}", (Object)player);
        }
        if (player != null && ClientHelper.isFlagged((Player)player)) {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)"ui.pvp_flagging.pvp_zone.entry_warning.flagged").m_130940_(ChatFormatting.RED), false);
        } else {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)"ui.pvp_flagging.pvp_zone.entry_warning.unflagged").m_130940_(ChatFormatting.RED), false);
        }
    }

    public static void handlePvpFlagUpdate(UUID playerUUID, boolean isFlagged) {
        LocalPlayer player;
        if (Logging.CLIENT_PVP_FLAG_CACHE) {
            PvpFlagging.LOGGER.debug("handlePvpFlagUpdate: playerUUID:{}, isFlagged:{}", (Object)playerUUID, (Object)isFlagged);
        }
        if ((player = Minecraft.m_91087_().f_91074_) != null && playerUUID.equals(player.m_20148_())) {
            if (isFlagged) {
                Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)"ui.pvp_flagging.pvp_on").m_130940_(ChatFormatting.RED), false);
            } else {
                Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)"ui.pvp_flagging.pvp_off").m_130940_(ChatFormatting.RED), false);
            }
        }
        if (isFlagged) {
            flaggedPlayerLookup.put(playerUUID, null);
        } else {
            flaggedPlayerLookup.remove(playerUUID);
        }
    }

    public static void handleFullPvpDataSync(ObjectSet<UUID> flaggedPlayers) {
        if (Logging.CLIENT_PVP_FLAG_CACHE) {
            PvpFlagging.LOGGER.debug("handleFullPvpDataSync: size:{}", (Object)flaggedPlayers.size());
        }
        HashMap tmp = new HashMap();
        flaggedPlayers.forEach(k -> tmp.put(k, null));
        flaggedPlayerLookup = tmp;
        unflagTimestamp = -1;
    }
}

