/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.valhelsia_structures.utils.ConfigurableValue;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public record ValhelsiaStructureSettings(@Nullable Double spawnChance, @Nullable Integer customMargin, @Nullable Boolean individualTerrainAdjustment) {
    @Nullable
    private final Double spawnChance;
    @Nullable
    private final Integer customMargin;
    @Nullable
    private final Boolean individualTerrainAdjustment;
    public static final ConfigurableValue<Integer> DEFAULT_MARGIN = ConfigurableValue.of(12);
    public static final MapCodec<ValhelsiaStructureSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("spawn_chance").forGetter(settings -> Optional.ofNullable(settings.spawnChance)), (App)Codec.INT.optionalFieldOf("custom_margin").forGetter(settings -> Optional.ofNullable(settings.customMargin)), (App)Codec.BOOL.optionalFieldOf("individual_terrain_adjustment").forGetter(settings -> Optional.ofNullable(settings.individualTerrainAdjustment))).apply((Applicative)instance, (spawnChance, customMargin, individualTerrainAdjustment) -> new ValhelsiaStructureSettings(spawnChance.orElse(null), customMargin.orElse(null), individualTerrainAdjustment.orElse(null))));

    public Double spawnChance() {
        return this.spawnChance == null ? 1.0 : this.spawnChance;
    }

    public Integer customMargin() {
        return this.customMargin == null ? DEFAULT_MARGIN.get() : this.customMargin;
    }

    public Boolean individualTerrainAdjustment() {
        return this.individualTerrainAdjustment != null && this.individualTerrainAdjustment != false;
    }
}

