/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetracelium.compat.twilightforest.effects;

import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.StatsHelper;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.getter.IStatFormat;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatFormat;
import se.mickelus.tetra.gui.stats.getter.StatGetterCooldown;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectEfficiency;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterMultiValue;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;
import se.mickelus.tetracelium.TetraceliumMod;
import se.mickelus.tetracelium.compat.twilightforest.effects.TwilightBoltPacket;
import twilightforest.entity.projectile.TwilightWandBolt;
import twilightforest.init.TFSounds;

public class TwilightBoltEffect {
    public static final ItemEffect twilightBoltEffect = ItemEffect.get((String)"twilightBolt");

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack itemStack = mc.f_91074_.m_21205_();
        if (event.isAttack() && !event.isCanceled() && itemStack.m_41720_() instanceof ItemModularHandheld && mc.f_91077_ != null && HitResult.Type.MISS.equals((Object)mc.f_91077_.m_6662_()) && TwilightBoltEffect.canTrigger((Player)mc.f_91074_, itemStack)) {
            TwilightBoltEffect.sendPacket();
        }
    }

    static boolean canTrigger(Player player, ItemStack itemStack) {
        return player.m_36403_(0.5f) > 0.9f && EffectHelper.getEffectLevel((ItemStack)itemStack, (ItemEffect)twilightBoltEffect) > 0 && !player.m_36335_().m_41519_(itemStack.m_41720_());
    }

    public static void sendPacket() {
        TetraceliumMod.packetHandler.sendToServer((AbstractPacket)new TwilightBoltPacket());
    }

    public static void handleServer(Player player) {
        ItemStack itemStack = player.m_21205_();
        if (TwilightBoltEffect.canTrigger(player, itemStack)) {
            TwilightBoltEffect.fireProjectile(player, player.m_9236_(), itemStack);
        }
    }

    static void fireProjectile(Player player, Level level, ItemStack itemStack) {
        player.m_5496_((SoundEvent)TFSounds.SCEPTER_PEARL.get(), 1.0f, (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f + 1.0f);
        level.m_7967_((Entity)new TwilightWandBolt(level, (LivingEntity)player));
        itemStack.m_220157_((int)Math.ceil((float)itemStack.m_41776_() * 0.01f), level.m_213780_(), null);
        player.m_36335_().m_41524_(itemStack.m_41720_(), (int)Math.ceil(((ItemModularHandheld)itemStack.m_41720_()).getCooldownBase(itemStack) * 4.0 * 20.0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientInit() {
        StatGetterEffectLevel statGetter = new StatGetterEffectLevel(twilightBoltEffect, 1.0);
        StatGetterEffectEfficiency efficiencyGetter = new StatGetterEffectEfficiency(twilightBoltEffect, 1.0);
        StatGetterCooldown cooldownGetter = new StatGetterCooldown(0.0, 4.0);
        GuiStatBar statBar = new GuiStatBar(0, 0, 59, "tetra.stats.twilightBolt", 0.0, 1.0, false, false, false, (IStatGetter)statGetter, LabelGetterBasic.noLabel, (ITooltipGetter)new TooltipGetterMultiValue("tetra.stats.twilightBolt.tooltip", StatsHelper.withStats((IStatGetter[])new IStatGetter[]{efficiencyGetter, cooldownGetter}), StatsHelper.withFormat((IStatFormat[])new IStatFormat[]{StatFormat.noDecimal, StatFormat.oneDecimal})));
        WorkbenchStatsGui.addBar((GuiStatBase)statBar);
        HoloStatsGui.addBar((GuiStatBase)statBar);
    }
}

