/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import de.mennomax.astikorcarts.entity.AbstractDrawnEntity;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public abstract class DrawnRenderer<T extends AbstractDrawnEntity, M extends EntityModel<T>>
extends EntityRenderer<T> {
    protected M model;
    private final ModelPart flag;
    private final ModelPart pole;
    private final ModelPart bar;
    private static final Field CHILD_MODELS = ObfuscationReflectionHelper.findField(ModelPart.class, (String)"f_104213_");

    protected DrawnRenderer(EntityRendererProvider.Context renderManager, M model) {
        super(renderManager);
        this.model = model;
        ModelPart banner = renderManager.m_174023_(ModelLayers.f_171264_);
        this.flag = banner.m_171324_("flag");
        this.pole = banner.m_171324_("pole");
        this.bar = banner.m_171324_("bar");
    }

    public void render(T entity, float yaw, float delta, PoseStack stack, MultiBufferSource source, int packedLight) {
        stack.m_85836_();
        AbstractDrawnEntity.RenderInfo info = ((AbstractDrawnEntity)((Object)entity)).getInfo(delta);
        this.setupRotation(entity, info.getYaw(), delta, stack);
        this.model.m_6973_(entity, delta, 0.0f, 0.0f, 0.0f, info.getPitch());
        VertexConsumer buf = source.m_6299_(this.model.m_103119_(this.m_5478_((Entity)entity)));
        this.model.m_7695_(stack, buf, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.renderContents(entity, delta, stack, source, packedLight);
        stack.m_85849_();
        super.m_7392_(entity, info.getYaw(), delta, stack, source, packedLight);
    }

    protected void renderContents(T entity, float delta, PoseStack stack, MultiBufferSource source, int packedLight) {
    }

    public void setupRotation(T entity, float entityYaw, float delta, PoseStack stack) {
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        float time = (float)((AbstractDrawnEntity)((Object)entity)).getTimeSinceHit() - delta;
        if (time > 0.0f) {
            double center = 1.2;
            stack.m_85837_(0.0, 1.2, 0.0);
            float damage = Math.max(((AbstractDrawnEntity)((Object)entity)).getDamageTaken() - delta, 0.0f);
            float angle = Mth.m_14031_((float)time) * time * damage / 60.0f;
            stack.m_252781_(Axis.f_252403_.m_252977_(angle * (float)((AbstractDrawnEntity)((Object)entity)).getForwardDirection()));
            stack.m_85837_(0.0, -1.2, 0.0);
            stack.m_85837_(0.0, (double)(angle / 32.0f), 0.0);
        }
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
    }

    protected void renderBanner(PoseStack stack, MultiBufferSource source, int packedLight, List<Pair<Holder<BannerPattern>, DyeColor>> banner) {
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        float scale = 0.6666667f;
        stack.m_85841_(0.6666667f, 0.6666667f, 0.6666667f);
        VertexConsumer consumer = ModelBakery.f_119224_.m_119194_(source, RenderType::m_110446_);
        this.pole.f_104205_ = -0.3f;
        this.pole.f_104200_ = 14.0f;
        this.pole.m_104301_(stack, consumer, packedLight, OverlayTexture.f_118083_);
        this.bar.f_104200_ = -4.0f;
        this.bar.f_104201_ = 4.0f;
        this.bar.f_104202_ = 0.1f;
        this.bar.m_104301_(stack, consumer, packedLight, OverlayTexture.f_118083_);
        this.flag.f_104200_ = -4.0f;
        this.flag.f_104201_ = -26.0f;
        this.flag.f_104202_ = 1.5f;
        this.flag.f_104203_ = 0.0f;
        BannerRenderer.m_112065_((PoseStack)stack, (MultiBufferSource)source, (int)packedLight, (int)OverlayTexture.f_118083_, (ModelPart)this.flag, (Material)ModelBakery.f_119224_, (boolean)true, banner);
        stack.m_85849_();
    }

    protected void attach(ModelPart bone, ModelPart attachment, Consumer<PoseStack> function, PoseStack stack) {
        stack.m_85836_();
        bone.m_104299_(stack);
        if (bone == attachment) {
            function.accept(stack);
        } else {
            Map childModels;
            try {
                childModels = (Map)CHILD_MODELS.get(bone);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            for (ModelPart child : childModels.values()) {
                this.attach(child, attachment, function, stack);
            }
        }
        stack.m_85849_();
    }
}

