/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.entity;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_machinery.Items;
import immersive_machinery.Sounds;
import immersive_machinery.client.KeyBindings;
import immersive_machinery.entity.MachineEntity;
import immersive_machinery.network.c2s.SonarMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class Copperfin
extends MachineEntity {
    public float waterSurface = 62.875f;
    public float dripping = 0.0f;
    public float bubbling = 0.0f;
    public int ambientSoundTime = 0;
    private int sonarCooldown = 0;

    public Copperfin(EntityType<? extends MachineEntity> entityType, Level world) {
        super(entityType, world, true);
    }

    public Item asItem() {
        return Items.COPPERFIN.get();
    }

    @Override
    protected void updateController() {
        super.updateController();
        --this.sonarCooldown;
        if (this.m_9236_().m_5776_() && KeyBindings.HORN.m_90859_() && this.sonarCooldown < 0) {
            this.requestSonar();
        }
        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(this.getSpeed() * this.getProperties().get(VehicleStat.VERTICAL_SPEED) * this.pressingInterpolatedY.getSmooth()), 0.0));
        Vector3f direction = this.getForwardDirection();
        float thrust = this.getSpeed() * this.pressingInterpolatedZ.getSmooth();
        Vector3f f = direction.mul(thrust);
        this.m_20256_(this.m_20184_().m_82520_((double)f.x, (double)f.y, (double)f.z));
    }

    @Override
    protected float getSpeed() {
        return super.getSpeed() * (this.m_5842_() ? 1.0f : 0.0f);
    }

    public boolean worksUnderWater() {
        return true;
    }

    protected SoundEvent getEngineStartSound() {
        return super.getEngineStartSound();
    }

    protected SoundEvent getEngineSound() {
        return Sounds.SUBMARINE_ENGINE.get();
    }

    protected float getGravity() {
        return this.m_5842_() ? 0.0f : super.getGravity();
    }

    protected float m_6380_(@NotNull Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.25f;
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        this.m_216990_(Sounds.HATCH_CLOSE.get());
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        this.m_216990_(Sounds.HATCH_OPEN.get());
    }

    public float getUnderwaterFraction() {
        return (float)Math.min(1.0, Math.max(0.0, ((double)this.waterSurface - this.m_20186_()) / (double)this.m_20206_()));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_46467_() % 13L == 0L) {
            boolean air = false;
            for (int y = (int)(this.m_20186_() + (double)this.m_20206_()); y >= this.m_146904_(); --y) {
                FluidState fluidState = this.m_9236_().m_6425_(new BlockPos(this.m_146903_(), y, this.m_146907_()));
                if (fluidState.m_76178_()) {
                    air = true;
                    continue;
                }
                if (!air) continue;
                float ownHeight = fluidState.m_76182_();
                this.waterSurface = (float)y + ownHeight;
                break;
            }
        }
        this.m_20197_().forEach(passenger -> {
            if (passenger instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)passenger;
                livingEntity.m_20301_(livingEntity.m_6062_());
            }
        });
        if (this.m_9236_().f_46443_) {
            this.tickClient();
        } else {
            this.tickServer();
        }
    }

    public void tickClient() {
        Vector3f pos;
        int i;
        float underwaterFraction = this.getUnderwaterFraction();
        if (underwaterFraction >= this.dripping) {
            this.dripping = underwaterFraction;
        } else if ((double)underwaterFraction < 0.6) {
            this.dripping = Math.max(0.0f, this.dripping - 0.005f);
            float r = this.f_19796_.m_188501_();
            this.spawnParticlesAround((ParticleOptions)ParticleTypes.f_123804_, 10.0f * this.dripping, 1.625f * r + 1.625f * underwaterFraction * (1.0f - r));
        }
        if (underwaterFraction <= this.bubbling) {
            this.bubbling = underwaterFraction;
        } else if ((double)underwaterFraction > 0.8) {
            this.bubbling = Math.min(1.0f, this.bubbling + 0.01f);
            this.spawnParticlesAround((ParticleOptions)ParticleTypes.f_123795_, 10.0f, this.f_19796_.m_188501_() * underwaterFraction);
        }
        float rawSpeed = (float)this.getCurrentSpeed();
        double speed = (double)rawSpeed * 3.0 + 0.5;
        if ((double)underwaterFraction > 0.6 && this.m_9236_().m_5776_() && this.pressingInterpolatedZ.getSmooth() > -0.01f && this.m_5842_()) {
            for (i = 0; i < (int)(speed * 2.5 + (double)this.f_19796_.m_188501_()); ++i) {
                pos = this.transformPosition(this.getVehicleTransform(), (this.f_19796_.m_188501_() - 0.5f) * 0.5f, (this.f_19796_.m_188501_() - 0.5f) * 0.5f + this.m_20206_() * 0.5f + 0.1f, -1.0f);
                Vector3f vec = this.transformVector(this.getVehicleNormalTransform(), 0.0f, 0.0f, -1.0f * (this.pressingInterpolatedZ.getSmooth() + 0.25f));
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, (double)pos.x, (double)pos.y, (double)pos.z, (double)vec.x, 0.0, (double)vec.z);
            }
        }
        this.m_146926_((float)((double)(this.pressingInterpolatedY.getSmooth() * -15.0f) * speed));
        this.setZRot((float)((double)(this.pressingInterpolatedX.getSmooth() * -20.0f) * speed));
        if ((double)underwaterFraction > 0.0 && (double)underwaterFraction < 1.0 && rawSpeed > 0.0f) {
            i = 0;
            while ((double)i < (double)rawSpeed * 8.0) {
                pos = this.getParticlePosition(0.0f);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, (double)pos.x, (double)this.waterSurface, (double)pos.z, 0.0, 1.0, 0.0);
                ++i;
            }
            if (this.f_19796_.m_188503_(10) == 0) {
                this.m_5496_(SoundEvents.f_11917_, 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
            }
        }
    }

    public void tickServer() {
        if (this.m_20160_()) {
            this.ambientSoundTime -= this.m_20186_() < this.lastY - 1.0E-5 ? 1 : 3;
            if (this.ambientSoundTime <= 0) {
                this.ambientSoundTime = 100 + this.f_19796_.m_188503_(250);
                this.m_216990_(Sounds.SUBMARINE_AMBIENCE.get());
            }
        }
    }

    public Vector3f getParticlePosition(float y) {
        float z;
        float x;
        boolean front = this.f_19796_.m_188499_();
        float w = 0.875f;
        float l = 1.0f;
        if (front) {
            x = (this.f_19796_.m_188501_() - 0.5f) * w;
            float mz = this.pressingInterpolatedZ.getSmooth();
            z = Math.abs(mz) < 0.01f ? (this.f_19796_.m_188499_() ? -l : l) : (mz > 0.0f ? -l : l);
        } else {
            x = this.f_19796_.m_188499_() ? -w : w;
            z = (this.f_19796_.m_188501_() - 0.5f) * l;
        }
        Vector4f vector4f = this.transformPosition(this.getVehicleTransform(), x, y, z);
        return new Vector3f(vector4f.x, vector4f.y, vector4f.z);
    }

    protected void spawnParticlesAround(ParticleOptions type, float amount, float height) {
        int i = 0;
        while ((float)i < amount + this.f_19796_.m_188501_()) {
            Vector3f pos = this.getParticlePosition(height);
            this.m_9236_().m_7106_(type, (double)pos.x, (double)pos.y, (double)pos.z, 0.0, 1.0, 0.0);
            ++i;
        }
    }

    public void requestSonar() {
        NetworkHandler.sendToServer((Message)new SonarMessage());
        this.sonarCooldown = 60;
    }

    public void sonar() {
        this.m_9236_().m_45933_((Entity)this, new AABB(this.m_20097_(), this.m_20097_()).m_82400_(48.0)).forEach(e -> {
            if (e instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)e;
                if (!e.m_20365_((Entity)this)) {
                    le.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 30));
                }
            }
        });
        this.m_216990_(Sounds.SONAR.get());
    }

    protected double getCurrentSpeed() {
        double dx = this.m_20185_() - this.f_19790_;
        double dz = this.m_20189_() - this.f_19792_;
        return Math.sqrt(dx * dx + dz * dz);
    }

    protected boolean m_7310_(@NotNull Entity passenger) {
        return this.m_20197_().size() < this.getPassengerSpace();
    }

    public Vector3f getForwardDirection() {
        return new Vector3f(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))), 0.0f, Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))).normalize();
    }

    public Vector3f getRightDirection() {
        return new Vector3f(Mth.m_14089_((float)(-this.m_146908_() * ((float)Math.PI / 180))), 0.0f, Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)))).normalize();
    }

    public Float modifyWaterVision(float waterVision) {
        return Float.valueOf(waterVision * 0.25f + 0.75f);
    }
}

