/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.client.AetherSoundEvents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class Sentry
extends Slime {
    private static final EntityDataAccessor<Boolean> DATA_AWAKE_ID = SynchedEntityData.m_135353_(Sentry.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float timeSpotted = 0.0f;

    public Sentry(EntityType<? extends Sentry> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SentryFloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SentryAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SentryRandomDirectionGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new SentryKeepOnJumpingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> Math.abs(entity.m_20186_() - this.m_20186_()) <= 4.0));
    }

    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.6).m_22266_(Attributes.f_22281_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_AWAKE_ID, (Object)false);
    }

    public void m_8119_() {
        if (this.m_9236_().m_5788_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 8.0, EntitySelector.f_20408_) != null) {
            if (!this.isAwake()) {
                if (this.timeSpotted >= 24.0f) {
                    this.setAwake(true);
                }
                this.timeSpotted += 1.0f;
            }
        } else {
            this.setAwake(false);
        }
        super.m_8119_();
    }

    protected void m_6135_() {
        if (this.isAwake()) {
            super.m_6135_();
        }
    }

    public void m_7334_(Entity entity) {
        super.m_7334_(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!(entity instanceof Sentry)) {
                this.explodeAt(livingEntity);
            }
        }
    }

    public void m_6123_(Player player) {
        if (EntitySelector.f_20406_.test(player)) {
            this.explodeAt((LivingEntity)player);
        }
    }

    protected void explodeAt(LivingEntity entity) {
        if (this.m_20280_((Entity)entity) < 1.5 && this.isAwake() && this.m_142582_((Entity)entity) && entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 1.0f) && this.f_19797_ > 20 && this.m_6084_()) {
            entity.m_5997_(0.3, 0.4, 0.3);
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, Level.ExplosionInteraction.MOB);
            this.m_5496_(SoundEvents.f_11913_, 1.0f, 0.2f * (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) + 1.0f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.m_7605_((Entity)this, (byte)70);
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.5);
            }
            this.m_19970_((LivingEntity)this, (Entity)entity);
            this.m_146870_();
        }
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        this.m_142467_(pReason);
        this.invalidateCaps();
    }

    public boolean isAwake() {
        return (Boolean)this.m_20088_().m_135370_(DATA_AWAKE_ID);
    }

    public void setAwake(boolean awake) {
        this.m_20088_().m_135381_(DATA_AWAKE_ID, (Object)awake);
    }

    public void m_7839_(int size, boolean resetHealth) {
    }

    protected ParticleOptions m_6300_() {
        return new BlockParticleOption(ParticleTypes.f_123794_, ((Block)AetherBlocks.SENTRY_STONE.get()).m_49966_());
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_SENTRY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SENTRY_DEATH.get();
    }

    protected SoundEvent m_7905_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SENTRY_JUMP.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SENTRY_AMBIENT.get();
    }

    protected SoundEvent m_7903_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SENTRY_SQUISH.get();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(1.76f);
    }

    protected boolean m_8028_() {
        return true;
    }

    public void m_7822_(byte id) {
        if (id == 70) {
            for (int i = 0; i < 40; ++i) {
                double x = this.m_20185_() + (double)this.m_217043_().m_188501_() * 0.25;
                double y = this.m_20186_() + 0.5;
                double z = this.m_20189_() + (double)this.m_217043_().m_188501_() * 0.25;
                float f1 = this.m_217043_().m_188501_() * 360.0f;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, x, y, z, -Math.sin((float)Math.PI / 180 * f1) * 0.75, 0.125, Math.cos((float)Math.PI / 180 * f1) * 0.75);
            }
        } else {
            super.m_7822_(id);
        }
    }

    static class SentryFloatGoal
    extends Slime.SlimeFloatGoal {
        private final Sentry sentry;

        public SentryFloatGoal(Sentry sentry) {
            super((Slime)sentry);
            this.sentry = sentry;
        }

        public boolean m_8036_() {
            return this.sentry.isAwake() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.sentry.isAwake() && super.m_8045_();
        }
    }

    static class SentryAttackGoal
    extends Slime.SlimeAttackGoal {
        private final Sentry sentry;

        public SentryAttackGoal(Sentry sentry) {
            super((Slime)sentry);
            this.sentry = sentry;
        }

        public boolean m_8036_() {
            return this.sentry.isAwake() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.sentry.isAwake() && super.m_8045_();
        }
    }

    static class SentryRandomDirectionGoal
    extends Slime.SlimeRandomDirectionGoal {
        private final Sentry sentry;

        public SentryRandomDirectionGoal(Sentry sentry) {
            super((Slime)sentry);
            this.sentry = sentry;
        }

        public boolean m_8036_() {
            return this.sentry.isAwake() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.sentry.isAwake() && super.m_8045_();
        }
    }

    static class SentryKeepOnJumpingGoal
    extends Slime.SlimeKeepOnJumpingGoal {
        private final Sentry sentry;

        public SentryKeepOnJumpingGoal(Sentry sentry) {
            super((Slime)sentry);
            this.sentry = sentry;
        }

        public boolean m_8036_() {
            return this.sentry.isAwake() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.sentry.isAwake() && super.m_8045_();
        }
    }
}

