/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.blockentity;

import com.aetherteam.aether.blockentity.AbstractAetherFurnaceBlockEntity;
import com.aetherteam.aether.blockentity.AetherBlockEntityTypes;
import com.aetherteam.aether.inventory.menu.FreezerMenu;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class FreezerBlockEntity
extends AbstractAetherFurnaceBlockEntity {
    private static final Map<Item, Integer> freezingMap = new LinkedHashMap<Item, Integer>();

    public FreezerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AetherBlockEntityTypes.FREEZER.get(), pos, state, (RecipeType<? extends AbstractCookingRecipe>)((RecipeType)AetherRecipeTypes.FREEZING.get()));
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"menu.aether.freezer");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInventory) {
        return new FreezerMenu(id, playerInventory, (Container)this, this.f_58311_);
    }

    protected int m_7743_(ItemStack fuelStack) {
        if (fuelStack.m_41619_() || !FreezerBlockEntity.getFreezingMap().containsKey(fuelStack.m_41720_())) {
            return 0;
        }
        return FreezerBlockEntity.getFreezingMap().get(fuelStack.m_41720_());
    }

    public static Map<Item, Integer> getFreezingMap() {
        return freezingMap;
    }

    public static void addItemFreezingTime(ItemLike itemProvider, int burnTime) {
        Item item = itemProvider.m_5456_();
        FreezerBlockEntity.getFreezingMap().put(item, burnTime);
    }

    public static void addItemsFreezingTime(ItemLike[] itemProviders, int burnTime) {
        Stream.of(itemProviders).map(ItemLike::m_5456_).forEach(item -> FreezerBlockEntity.getFreezingMap().put((Item)item, burnTime));
    }

    public static void addItemTagFreezingTime(TagKey<Item> itemTag, int burnTime) {
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        if (tags != null) {
            tags.getTag(itemTag).stream().forEach(item -> FreezerBlockEntity.getFreezingMap().put((Item)item, burnTime));
        }
    }

    public static void removeItemFreezingTime(ItemLike itemProvider) {
        Item item = itemProvider.m_5456_();
        FreezerBlockEntity.getFreezingMap().remove(item);
    }

    public static void removeItemsFreezingTime(ItemLike[] itemProviders) {
        Stream.of(itemProviders).map(ItemLike::m_5456_).forEach(item -> FreezerBlockEntity.getFreezingMap().remove(item));
    }

    public static void removeItemTagFreezingTime(TagKey<Item> itemTag) {
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        if (tags != null) {
            tags.getTag(itemTag).stream().forEach(item -> FreezerBlockEntity.getFreezingMap().remove(item));
        }
    }
}

