/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.waystones;

import io.github.lightman314.lightmanscompat.waystones.WarpDistanceCache;
import io.github.lightman314.lightmanscompat.waystones.WaystonesConfig;
import io.github.lightman314.lightmanscompat.waystones.WaystonesEventListener;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.WarpMode;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WaystonesNode {
    public static final Logger LOGGER = LogManager.getLogger();

    public static void setup() {
        MinecraftForge.EVENT_BUS.register(WaystonesEventListener.class);
        WaystonesConfig.init();
    }

    public static MoneyValue calculatePrice(Player player, IWaystone target, WarpMode warpMode, int leashed) {
        return WaystonesNode.calculatePrice(target, warpMode, leashed, new WarpDistanceCache(player, target));
    }

    public static MoneyValue calculatePrice(IWaystone target, WarpMode mode, int leashed, WarpDistanceCache distanceData) {
        MoneyValue maxCost;
        MoneyValue minCost;
        MoneyValue leashedPrice;
        MoneyValue price;
        if (mode == WarpMode.BOUND_SCROLL || mode == WarpMode.RETURN_SCROLL || mode == WarpMode.WARP_SCROLL) {
            return MoneyValue.empty();
        }
        if (target.getDimension().m_135782_().equals((Object)distanceData.originalDimension)) {
            price = (MoneyValue)WaystonesConfig.CONFIG.baseWarpPrice.get();
            MoneyValue distancePrice = (MoneyValue)WaystonesConfig.CONFIG.distanceScaledPrice.get();
            double distancePerPrice = (Double)WaystonesConfig.CONFIG.distancePerScaledPrice.get();
            if (distancePerPrice > 0.0 && !distancePrice.isEmpty()) {
                double mult = distanceData.distance / distancePerPrice;
                MoneyValue addPrice = distancePrice.multiplyValue(mult);
                if (((Boolean)WaystonesConfig.CONFIG.invertMoneyCost.get()).booleanValue() && (addPrice = ((MoneyValue)WaystonesConfig.CONFIG.maxWarpCost.get()).subtractValue(addPrice)) == null) {
                    addPrice = MoneyValue.empty();
                }
                price = price.isEmpty() ? addPrice : price.addValue(addPrice);
            }
        } else {
            price = (MoneyValue)WaystonesConfig.CONFIG.dimensionalWarpPrice.get();
        }
        if (leashed > 0 && !(leashedPrice = (MoneyValue)WaystonesConfig.CONFIG.leashedWarpPrice.get()).isEmpty()) {
            leashedPrice = leashedPrice.multiplyValue((double)leashed);
            price = price.isEmpty() ? leashedPrice : price.addValue(leashedPrice);
            LOGGER.debug("{} leashed animals detected. Price is now {}", (Object)leashed, (Object)price.getString("Empty"));
        }
        if ((minCost = (MoneyValue)WaystonesConfig.CONFIG.minWarpCost.get()).sameType(maxCost = (MoneyValue)WaystonesConfig.CONFIG.maxWarpCost.get()) && minCost.getCoreValue() > maxCost.getCoreValue()) {
            MoneyValue temp = minCost;
            minCost = maxCost;
            maxCost = temp;
        }
        if (minCost.sameType(price) && minCost.getCoreValue() > price.getCoreValue()) {
            price = minCost;
        }
        if (maxCost.sameType(price) && !maxCost.isEmpty() && maxCost.getCoreValue() < price.getCoreValue()) {
            price = maxCost;
        }
        if (mode == WarpMode.INVENTORY_BUTTON) {
            price = price.multiplyValue(((Double)WaystonesConfig.CONFIG.inventoryButtonCostScale.get()).doubleValue());
        }
        if (mode == WarpMode.WARP_STONE) {
            price = price.multiplyValue(((Double)WaystonesConfig.CONFIG.warpStonePriceScale.get()).doubleValue());
        }
        if (mode == WarpMode.WAYSTONE_TO_WAYSTONE) {
            price = price.multiplyValue(((Double)WaystonesConfig.CONFIG.waystonePriceScale.get()).doubleValue());
        }
        if (mode == WarpMode.SHARESTONE_TO_SHARESTONE) {
            price = price.multiplyValue(((Double)WaystonesConfig.CONFIG.sharestonePriceScale.get()).doubleValue());
        }
        if (mode == WarpMode.PORTSTONE_TO_WAYSTONE) {
            price = price.multiplyValue(((Double)WaystonesConfig.CONFIG.portstonePriceScale.get()).doubleValue());
        }
        if (mode == WarpMode.WARP_PLATE) {
            price = price.multiplyValue(((Double)WaystonesConfig.CONFIG.warpPlatePriceScale.get()).doubleValue());
        }
        if (target.isGlobal()) {
            price = price.multiplyValue(((Double)WaystonesConfig.CONFIG.globalCostScale.get()).doubleValue());
        }
        return price;
    }
}

