/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.waystones;

import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.SyncedConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.BooleanOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.DoubleOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.MoneyValueOption;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class WaystonesConfig
extends SyncedConfigFile {
    public static final WaystonesConfig CONFIG = new WaystonesConfig();
    public final BooleanOption invertMoneyCost = BooleanOption.createFalse();
    public final MoneyValueOption baseWarpPrice = MoneyValueOption.create(MoneyValue::empty);
    public final MoneyValueOption distanceScaledPrice = MoneyValueOption.create(MoneyValue::empty);
    public final DoubleOption distancePerScaledPrice = DoubleOption.create((double)100.0, (double)0.0, (double)Double.MAX_VALUE);
    public final MoneyValueOption leashedWarpPrice = MoneyValueOption.create(MoneyValue::empty);
    public final MoneyValueOption dimensionalWarpPrice = MoneyValueOption.create(MoneyValue::empty);
    public final DoubleOption globalCostScale = DoubleOption.create((double)0.0, (double)0.0, (double)Double.MAX_VALUE);
    public final DoubleOption warpStonePriceScale = DoubleOption.create((double)0.0, (double)0.0, (double)Double.MAX_VALUE);
    public final DoubleOption waystonePriceScale = DoubleOption.create((double)1.0, (double)0.0, (double)Double.MAX_VALUE);
    public final DoubleOption sharestonePriceScale = DoubleOption.create((double)0.0, (double)0.0, (double)Double.MAX_VALUE);
    public final DoubleOption portstonePriceScale = DoubleOption.create((double)0.0, (double)0.0, (double)Double.MAX_VALUE);
    public final DoubleOption warpPlatePriceScale = DoubleOption.create((double)0.0, (double)0.0, (double)Double.MAX_VALUE);
    public final DoubleOption inventoryButtonCostScale = DoubleOption.create((double)0.0, (double)0.0, (double)Double.MAX_VALUE);
    public final MoneyValueOption minWarpCost = MoneyValueOption.create(MoneyValue::empty);
    public final MoneyValueOption maxWarpCost = MoneyValueOption.create(MoneyValue::empty);

    public static void init() {
        CONFIG.confirmSetup();
    }

    private WaystonesConfig() {
        super("lcompat_waystones", VersionUtil.modResource((String)"lcompat", (String)"waystones"));
    }

    protected void setup(ConfigFile.ConfigBuilder builder) {
        builder.comment(new String[]{"Set to true if the warp cost should be inverted, meaning the shorter the distance, the more expensive", "This will be done by calculating the price normally and subtracting it from the max warp cost defined below"}).add("invertWarpCost", (ConfigOption)this.invertMoneyCost);
        builder.comment(new String[]{"The base cost to warp using a Waystone"}).add("baseWarpCost", (ConfigOption)this.baseWarpPrice);
        builder.comment(new String[]{"The distance scaled cost to warp using a Waystone"}).add("distanceScaledCost", (ConfigOption)this.distanceScaledPrice);
        builder.comment(new String[]{"The distance per distance scaled cost in meters"}).add("distancePerScaledCost", (ConfigOption)this.distancePerScaledPrice);
        builder.comment(new String[]{"How much is costs per leashed animal traveling with you"}).add("warpCostPerLeashed", (ConfigOption)this.leashedWarpPrice);
        builder.comment(new String[]{"The cost to warp from one dimension to another using a Waystone"}).add("crossDimensionWarpCost", (ConfigOption)this.dimensionalWarpPrice);
        builder.comment(new String[]{"The warp cost scale when warping to a Global Waystone"}).add("globalWaystoneCostScale", (ConfigOption)this.globalCostScale);
        builder.comment(new String[]{"The warp cost scale when warping using a Warp Stone item"}).add("warpStoneCostScale", (ConfigOption)this.warpStonePriceScale);
        builder.comment(new String[]{"The warp cost scale when warping from one waystone to another"}).add("waystoneCostScale", (ConfigOption)this.waystonePriceScale);
        builder.comment(new String[]{"The warp cost scale when warping from one sharestone to another"}).add("sharestoneCostScale", (ConfigOption)this.sharestonePriceScale);
        builder.comment(new String[]{"The warp cost scale when warping from a portstone"}).add("portstoneCostScale", (ConfigOption)this.portstonePriceScale);
        builder.comment(new String[]{"The warp cost scale when warping using a Warp Plate"}).add("warpPlateCostScale", (ConfigOption)this.warpPlatePriceScale);
        builder.comment(new String[]{"The warp cost scale when warping via the inventory button"}).add("inventoryButtonCostScale", (ConfigOption)this.inventoryButtonCostScale);
        builder.comment(new String[]{"The minimum warp cost regardless of distance, etc. (may be subceeded by multipliers defined below)"}).add("minWarpCost", (ConfigOption)this.minWarpCost);
        builder.comment(new String[]{"The maximum warp cost regardless of distance, etc. (may be exceeded by multipliers defined below)"}).add("maxWarpCost", (ConfigOption)this.maxWarpCost);
    }
}

