/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.network;

import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class LCompatPacketHandler {
    public static final String PROTOCOL_VERSION = "1";
    public static SimpleChannel instance;
    private static final List<Consumer<PacketRegistration>> packetNodes;

    public static void registerNode(Consumer<PacketRegistration> node) {
        packetNodes.add(node);
    }

    public static void init() {
        instance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)VersionUtil.modResource((String)"lcompat", (String)"network")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
        PacketRegistration r = new PacketRegistration(instance, 0);
        for (Consumer<PacketRegistration> consumer : packetNodes) {
            consumer.accept(r);
        }
    }

    static {
        packetNodes = new ArrayList<Consumer<PacketRegistration>>();
    }

    public static class PacketRegistration {
        private final SimpleChannel channel;
        private int nextID;

        private PacketRegistration(SimpleChannel channel, int nextID) {
            this.channel = channel;
            this.nextID = nextID;
        }

        public <T extends CustomPacket> void register(Class<T> clazz, CustomPacket.Handler<T> handler) {
            this.channel.registerMessage(this.nextID++, clazz, CustomPacket::encode, arg_0 -> handler.decode(arg_0), (arg_0, arg_1) -> handler.handlePacket(arg_0, arg_1));
        }
    }
}

