/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.mixin.waystones;

import io.github.lightman314.lightmanscompat.waystones.WaystonesNode;
import io.github.lightman314.lightmanscompat.waystones.WaystonesText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import java.util.ArrayList;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.client.gui.screen.WaystoneSelectionScreenBase;
import net.blay09.mods.waystones.client.gui.widget.WaystoneButton;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WaystoneButton.class})
public class WaystoneButtonMixin {
    @Unique
    private MoneyValue lightmansCompat$price;
    @Final
    @Shadow
    private IWaystone waystone;
    @Shadow
    @Final
    private int xpLevelCost;

    @Unique
    protected WaystoneButton lightmansCompat$self() {
        return (WaystoneButton)this;
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void init(int x, int y, IWaystone waystone, int xpLevelCost, Button.OnPress pressable, CallbackInfo ci) {
        WaystoneButton self = this.lightmansCompat$self();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            this.lightmansCompat$price = MoneyValue.empty();
            return;
        }
        WarpMode mode = WarpMode.CUSTOM;
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof WaystoneSelectionScreenBase) {
            WaystoneSelectionScreenBase screen2 = (WaystoneSelectionScreenBase)screen;
            mode = ((WaystoneSelectionMenu)screen2.m_6262_()).getWarpMode();
        } else {
            screen = Minecraft.m_91087_().f_91074_.f_36096_;
            if (screen instanceof WaystoneSelectionMenu) {
                WaystoneSelectionMenu menu = (WaystoneSelectionMenu)screen;
                mode = menu.getWarpMode();
            } else {
                WaystonesNode.LOGGER.warn("Waystone button created from a non-waystone screen. May be unable to calculate the price accurately!");
            }
        }
        int leashed = PlayerWaystoneManager.findLeashedAnimals((Entity)Minecraft.m_91087_().f_91074_).size();
        this.lightmansCompat$price = WaystonesNode.calculatePrice((Player)player, this.waystone, mode, leashed);
        if (this.lightmansCompat$price.isEmpty() || player.m_150110_().f_35937_ || !this.lightmansCompat$self().f_93623_) {
            return;
        }
        IMoneyHolder moneyHandler = MoneyAPI.API.GetPlayersMoneyHandler((Player)player);
        if (!moneyHandler.getStoredMoney().containsValue(this.lightmansCompat$price)) {
            self.f_93623_ = false;
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"renderWidget"})
    private void renderWidget(GuiGraphics mcgui, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (this.lightmansCompat$price.isEmpty()) {
            return;
        }
        WaystoneButton self = this.lightmansCompat$self();
        EasyGuiGraphics gui = EasyGuiGraphics.create((GuiGraphics)mcgui, (int)mouseX, (int)mouseY, (float)partialTicks);
        gui.pushOffset((AbstractWidget)self);
        DisplayEntry entry = this.lightmansCompat$price.getDisplayEntry(new ArrayList(), true);
        int xOffset = this.xpLevelCost > 0 ? 16 : 0;
        entry.render(gui, xOffset + 2, 2, new DisplayData(0, 0, 32, 16));
        if (self.m_274382_() && mouseX >= self.m_252754_() + xOffset && mouseX <= self.m_252754_() + xOffset + 32) {
            gui.resetColor();
            gui.renderTooltip((Component)WaystonesText.TOOLTIP_WAYSTONE_MONEY_COST.get(new Object[]{this.lightmansCompat$price.getText()}));
        }
    }
}

