/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.trader_storage;

import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.ClaimShopData;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.client.menu.trader_storage.ClaimTradeEditClientTab;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class ClaimTradeEditTab
extends TraderStorageTab {
    public ClaimTradeEditTab(@Nonnull ITraderStorageMenu menu) {
        super(menu);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new ClaimTradeEditClientTab(screen, this);
    }

    public boolean canOpen(Player player) {
        return true;
    }

    public boolean canEditTrade() {
        return ((ITraderStorageMenu)this.menu).hasPermission("editTrades");
    }

    public boolean canEditRentMode() {
        ClaimShopData shop;
        TraderData traderData;
        return ((ITraderStorageMenu)this.menu).hasPermission("editTrades") && (traderData = ((ITraderStorageMenu)this.menu).getTrader()) instanceof ClaimShopData && !(shop = (ClaimShopData)traderData).isActive() && !shop.isLocked();
    }

    public void SetActive(boolean active) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData) {
            ClaimShopData shop = (ClaimShopData)traderData;
            if (this.canEditTrade()) {
                shop.setActive(active);
                if (this.isClient()) {
                    ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setBoolean("SetActive", active));
                }
            }
        }
    }

    public void SetPrice(MoneyValue price) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData) {
            ClaimShopData shop = (ClaimShopData)traderData;
            if (this.canEditTrade()) {
                shop.setPrice(price);
                if (this.isClient()) {
                    ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setMoneyValue("SetPrice", price));
                }
            }
        }
    }

    public void SetRentMode(boolean rentMode) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData) {
            ClaimShopData shop = (ClaimShopData)traderData;
            if (this.canEditRentMode()) {
                shop.setRentMode(rentMode);
                if (this.isClient()) {
                    ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setBoolean("SetRentMode", rentMode));
                }
            }
        }
    }

    public boolean canReclaimBlock() {
        ClaimShopData shop;
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        return traderData instanceof ClaimShopData && (shop = (ClaimShopData)traderData).hasBeenPurchased() && shop.getBlockEntity() != null;
    }

    public void ReclaimBlock() {
        TraderBlockEntity be;
        ClaimShopData shop;
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData && (shop = (ClaimShopData)traderData).hasBeenPurchased() && (be = shop.getBlockEntity()) != null) {
            Level level = be.m_58904_();
            assert (level != null);
            List contents = shop.getContents(level, be.m_58899_(), be.m_58900_(), true);
            for (ItemStack item : contents) {
                ItemHandlerHelper.giveItemToPlayer((Player)((ITraderStorageMenu)this.menu).getPlayer(), (ItemStack)item);
            }
            be.flagAsLegitBreak();
            level.m_46597_(be.m_58899_(), Blocks.f_50016_.m_49966_());
        }
    }

    public void receiveMessage(LazyPacketData message) {
        if (message.contains("SetActive")) {
            this.SetActive(message.getBoolean("SetActive"));
        }
        if (message.contains("SetPrice")) {
            this.SetPrice(message.getMoneyValue("SetPrice"));
        }
        if (message.contains("SetRentMode")) {
            this.SetRentMode(message.getBoolean("SetRentMode"));
        }
        if (message.contains("ReclaimBlock")) {
            this.ReclaimBlock();
        }
    }
}

