/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.trader_storage;

import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.ClaimShopData;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.client.menu.trader_storage.ClaimMapClientTab;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClaimMapTab
extends TraderStorageTab {
    public ClaimMapTab(@Nonnull ITraderStorageMenu menu) {
        super(menu);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new ClaimMapClientTab(screen, this);
    }

    public boolean canOpen(Player player) {
        return ((ITraderStorageMenu)this.menu).hasPermission("editTrades");
    }

    public boolean isNotLocked() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData) {
            ClaimShopData shop = (ClaimShopData)traderData;
            return !shop.isActive() && !shop.isLocked();
        }
        return false;
    }

    public void DeselectChunk(ChunkPos chunk) {
        ClaimShopData shop;
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData && (shop = (ClaimShopData)traderData).hasPermission(((ITraderStorageMenu)this.menu).getPlayer(), "editTrades")) {
            shop.removeChunkTarget(chunk);
            if (this.isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setFlag("RemoveChunk").setInt("ChunkX", chunk.f_45578_).setInt("ChunkZ", chunk.f_45579_));
            }
        }
    }

    public void SelectChunk(ChunkPos chunk) {
        ClaimShopData shop;
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData && (shop = (ClaimShopData)traderData).hasPermission(((ITraderStorageMenu)this.menu).getPlayer(), "editTrades")) {
            shop.addChunkTarget(chunk);
            if (this.isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setFlag("AddChunk").setInt("ChunkX", chunk.f_45578_).setInt("ChunkZ", chunk.f_45579_));
            }
        }
    }

    public void TryQuickClaim() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData) {
            ClaimShopData shop = (ClaimShopData)traderData;
            if (shop.isActive() || shop.isLocked()) {
                return;
            }
            if (this.isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setFlag("TryQuickClaim"));
            } else {
                shop.reclaimLand(shop.getOwner().getValidOwner().asPlayerReference(), null);
            }
        }
    }

    public void receiveMessage(LazyPacketData message) {
        if (message.contains("AddChunk") || message.contains("RemoveChunk")) {
            ChunkPos chunk = new ChunkPos(message.getInt("ChunkX"), message.getInt("ChunkZ"));
            if (message.contains("AddChunk")) {
                this.SelectChunk(chunk);
            } else {
                this.DeselectChunk(chunk);
            }
        }
        if (message.contains("TryQuickClaim")) {
            this.TryQuickClaim();
        }
    }
}

