/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.client.menu.trader_storage;

import io.github.lightman314.lightmanscompat.ftbchunks.FTBChunksText;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.ClaimShopData;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.trader_storage.ClaimRentTab;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ClaimRentClientTab
extends TraderStorageClientTab<ClaimRentTab> {
    public ClaimRentClientTab(Object screen, ClaimRentTab commonTab) {
        super(screen, (TraderStorageTab)commonTab);
    }

    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(30, 20))).sprite(IconAndButtonUtil.SPRITE_PLUS).pressAction(() -> ((ClaimRentTab)this.commonTab).SetMaxRentPayments(Math.min(99, this.getMaxRentPayments() + this.getDeltaValue())))).addon(EasyAddonHelper.activeCheck(() -> this.getMaxRentPayments() < 99))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(30, 30))).sprite(IconAndButtonUtil.SPRITE_MINUS).pressAction(() -> ((ClaimRentTab)this.commonTab).SetMaxRentPayments(Math.max(1, this.getMaxRentPayments() - this.getDeltaValue())))).addon(EasyAddonHelper.activeCheck(() -> this.getMaxRentPayments() > 1))).build());
        this.addChild(((TimeInputWidget.Builder)((TimeInputWidget.Builder)TimeInputWidget.builder().position(screenArea.pos.offset(screenArea.width / 2 - 25, 85))).startTime(this.getRentDuration()).unitRange(TimeUtil.TimeUnit.HOUR, TimeUtil.TimeUnit.DAY).maxDuration(2592000000L).handler(duration -> ((ClaimRentTab)this.commonTab).SetRentDuration(duration.miliseconds)).addon(EasyAddonHelper.activeCheck(() -> !((ClaimRentTab)this.commonTab).isLocked()))).build());
    }

    public void renderBG(EasyGuiGraphics gui) {
        gui.drawString((Component)FTBChunksText.GUI_CLAIM_SHOP_MAX_RENT_PAYMENTS.get(new Object[]{this.getMaxRentPayments()}), 42, 26, 0x404040);
        long duration = this.getRentDuration();
        MutableComponent message = duration < 3600000L ? FTBChunksText.GUI_CLAIM_SHOP_RENT_DURATION_EMPTY.get(new Object[0]) : FTBChunksText.GUI_CLAIM_SHOP_RENT_DURATION.get(new Object[]{new TimeUtil.TimeData(duration).getString()});
        TextRenderUtil.drawCenteredMultilineText((EasyGuiGraphics)gui, (Component)message, (int)30, (int)(((ITraderStorageScreen)this.screen).getXSize() - 60), (int)55, (int)0x404040);
    }

    private int getMaxRentPayments() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData) {
            ClaimShopData shop = (ClaimShopData)traderData;
            return shop.getMaxRentPayments();
        }
        return 1;
    }

    private int getDeltaValue() {
        int amount = 1;
        if (Screen.m_96638_()) {
            amount += 9;
        }
        if (Screen.m_96637_()) {
            amount *= 10;
        }
        return amount;
    }

    private long getRentDuration() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData) {
            ClaimShopData shop = (ClaimShopData)traderData;
            return shop.getRentDuration();
        }
        return 0L;
    }

    public IconData getIcon() {
        return IconUtil.ICON_TRADER_ALT;
    }

    @Nullable
    public Component getTooltip() {
        return FTBChunksText.TOOLTIP_CLAIM_SHOP_RENT.get(new Object[0]);
    }
}

