/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.client.menu.trader_storage;

import io.github.lightman314.lightmanscompat.api.client.widgets.map.ChunkFrame;
import io.github.lightman314.lightmanscompat.api.client.widgets.map.MapRegionWidget;
import io.github.lightman314.lightmanscompat.ftbchunks.FTBChunksText;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.ClaimShopData;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.trader_storage.ClaimMapTab;
import io.github.lightman314.lightmanscompat.ftbchunks.util.FTBChunksHelper;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ClaimMapClientTab
extends TraderStorageClientTab<ClaimMapTab> {
    private MapRegionWidget map;

    public ClaimMapClientTab(Object screen, ClaimMapTab commonTab) {
        super(screen, (TraderStorageTab)commonTab);
    }

    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        TraderData traderData;
        if (this.map != null) {
            this.map.discard();
        }
        if ((traderData = ((ITraderStorageMenu)this.menu).getTrader()) instanceof ClaimShopData) {
            ClaimShopData shop = (ClaimShopData)traderData;
            this.map = (MapRegionWidget)((Object)this.addChild((Object)((MapRegionWidget.Builder)((MapRegionWidget.Builder)MapRegionWidget.builder().position(screenArea.pos.offset(screenArea.width / 2 - 63, 13))).withRadius(3).withCenterChunk(shop.getWorldPosition()).withFrame(this::getFrame).withTooltip(this::getTooltip).withHandler(this::toggleSelection).addon(EasyAddonHelper.activeCheck(((ClaimMapTab)this.commonTab)::isNotLocked))).build()));
            this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width - 30, 13))).pressAction(((ClaimMapTab)this.commonTab)::TryQuickClaim)).icon(IconUtil.ICON_ALEX_HEAD).addon(EasyAddonHelper.activeCheck(() -> ((ClaimMapTab)this.commonTab).isNotLocked() && this.hasUnclaimedChunk()))).addon(EasyAddonHelper.tooltip((TextEntry)FTBChunksText.TOOLTIP_CLAIM_SHOP_QUICK_CLAIM))).build());
        }
    }

    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TextRenderUtil.drawCenteredText((EasyGuiGraphics)gui, (Component)FTBChunksText.GUI_CLAIM_SHOP_MAP_LABEL.get(new Object[0]), (int)(((ITraderStorageScreen)this.screen).getXSize() / 2), (int)4, (int)0x404040);
    }

    protected void closeAction() {
        if (this.map != null) {
            this.map.discard();
        }
    }

    private boolean isSelected(ChunkPos chunk) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData) {
            ClaimShopData shop = (ClaimShopData)traderData;
            return shop.getChunkTargets().contains(chunk);
        }
        return false;
    }

    private ChunkFrame getFrame(ChunkPos chunk) {
        ClaimShopData shop;
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData && (shop = (ClaimShopData)traderData).getChunkTargets().contains(chunk)) {
            ResourceKey dimension = shop.getWorldPosition().getDimension();
            if (dimension == null) {
                return ChunkFrame.ERROR;
            }
            if (FTBChunksHelper.isChunkOwner(shop.getOwner().getValidOwner().asPlayerReference(), (ResourceKey<Level>)dimension, chunk, true)) {
                return ChunkFrame.GOOD;
            }
            UUID otherOwner = FTBChunksHelper.getChunkOwnerID((ResourceKey<Level>)dimension, chunk, true);
            return otherOwner == null ? ChunkFrame.WARNING : ChunkFrame.ERROR;
        }
        return ChunkFrame.NEUTRAL;
    }

    @Nullable
    private Component getTooltip(ChunkPos chunk) {
        ClaimShopData shop;
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData && (shop = (ClaimShopData)traderData).getChunkTargets().contains(chunk)) {
            ResourceKey dimension = shop.getWorldPosition().getDimension();
            if (dimension == null) {
                return null;
            }
            if (FTBChunksHelper.isChunkOwner(shop.getOwner().getPlayerForContext(), (ResourceKey<Level>)dimension, chunk, true)) {
                return null;
            }
            Component otherOwner = FTBChunksHelper.getChunkOwnerName((ResourceKey<Level>)dimension, chunk, true);
            if (otherOwner != null) {
                return FTBChunksText.TOOLTIP_CLAIM_SHOP_MAP_CLAIMED_BY_OTHER.get(new Object[]{otherOwner});
            }
            return FTBChunksText.TOOLTIP_CLAIM_SHOP_MAP_UNCLAIMED.get(new Object[0]);
        }
        return null;
    }

    private void toggleSelection(ChunkPos chunk) {
        if (this.isSelected(chunk)) {
            ((ClaimMapTab)this.commonTab).DeselectChunk(chunk);
        } else {
            ((ClaimMapTab)this.commonTab).SelectChunk(chunk);
        }
    }

    private boolean hasUnclaimedChunk() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData) {
            ClaimShopData shop = (ClaimShopData)traderData;
            ResourceKey dimension = shop.getWorldPosition().getDimension();
            if (dimension == null) {
                return false;
            }
            for (ChunkPos chunk : shop.getChunkTargets()) {
                if (FTBChunksHelper.getChunkOwnerID((ResourceKey<Level>)dimension, chunk, true) != null) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42573_);
    }

    @Nullable
    public Component getTooltip() {
        return FTBChunksText.TOOLTIP_CLAIM_SHOP_MAP.get(new Object[0]);
    }
}

