/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader;

import io.github.lightman314.lightmanscompat.ftbchunks.FTBChunksText;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.ClaimShopData;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.client.ClaimShopTradeButtonRenderer;
import io.github.lightman314.lightmanscompat.ftbchunks.util.FTBTeamHelper;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ClaimShopTrade
extends TradeData {
    public final ClaimShopData trader;

    public ClaimShopTrade(ClaimShopData trader) {
        super(false);
        this.trader = trader;
    }

    @Nonnull
    public MoneyValue getCost() {
        return this.trader.getPrice();
    }

    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        MoneyValue cost;
        super.beforeTrade(event);
        if (!this.trader.isActive()) {
            event.addDenial(FTBChunksText.TOOLTIP_CLAIM_SHOP_NOT_ACTIVATED.get(new Object[0]));
            return;
        }
        TradeContext context = event.getContext();
        if (!context.hasFunds(cost = this.getCost(context))) {
            event.addWarning(LCText.TOOLTIP_CANNOT_AFFORD.get(new Object[0]));
        }
        if (FTBTeamHelper.isOnSameTeam(context.getPlayerReference(), this.trader.getOwner().getValidOwner().asPlayerReference(), this.trader.isClient())) {
            event.addDenial(FTBChunksText.TOOLTIP_CLAIM_SHOP_SAME_TEAM.get(new Object[0]));
        }
        if (this.trader.isRentMode()) {
            PlayerReference renter = this.trader.getCustomer();
            if (this.trader.isCurrentlyRented() && renter != null) {
                if (!FTBTeamHelper.isOnSameTeam(context.getPlayerReference(), renter, this.trader.isClient())) {
                    event.addDenial(FTBChunksText.TOOLTIP_CLAIM_SHOP_RENTED_BY_OTHER.get(new Object[0]));
                } else if (this.trader.getPrepaidCount() >= this.trader.getMaxRentPayments()) {
                    event.addDenial(FTBChunksText.TOOLTIP_CLAIM_SHOP_RENT_LIMIT.get(new Object[]{this.trader.getMaxRentPayments()}));
                }
            }
        } else if (this.trader.hasBeenPurchased()) {
            event.addDenial(FTBChunksText.TOOLTIP_CLAIM_SHOP_PURCHASED_BY_OTHER.get(new Object[0]));
        }
        if (this.trader.exceedsGroupLimit(context.getPlayerReference())) {
            event.addDenial(FTBChunksText.TOOLTIP_CLAIM_SHOP_GROUP_LIMIT.get(new Object[]{this.trader.getGroupLimit()}));
        }
    }

    public boolean allowTradeRule(TradeRule rule) {
        return false;
    }

    public TradeDirection getTradeDirection() {
        return TradeDirection.SALE;
    }

    public int getStock(@Nonnull TradeContext tradeContext) {
        return this.trader.getTradeStock(0);
    }

    public TradeComparisonResult compare(TradeData tradeData) {
        return new TradeComparisonResult();
    }

    public boolean AcceptableDifferences(TradeComparisonResult tradeComparisonResult) {
        return false;
    }

    public List<Component> GetDifferenceWarnings(TradeComparisonResult tradeComparisonResult) {
        return List.of();
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRenderManager<?> getButtonRenderer() {
        return new ClaimShopTradeButtonRenderer(this);
    }

    public void OnInputDisplayInteraction(@Nonnull BasicTradeEditTab basicTradeEditTab, int i, @Nonnull TradeInteractionData tradeInteractionData, @Nonnull ItemStack itemStack) {
    }

    public void OnOutputDisplayInteraction(@Nonnull BasicTradeEditTab basicTradeEditTab, int i, @Nonnull TradeInteractionData tradeInteractionData, @Nonnull ItemStack itemStack) {
    }

    public void OnInteraction(@Nonnull BasicTradeEditTab basicTradeEditTab, @Nonnull TradeInteractionData tradeInteractionData, @Nonnull ItemStack itemStack) {
    }
}

