/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscompat.api.claimshop.ClaimGroupData;
import io.github.lightman314.lightmanscompat.api.claimshop.IGroupableClaimTrader;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.block.ClaimShopState;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.notifications.LandPurchaseNotification;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.notifications.RentDueNotification;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.notifications.RentExpiredNotification;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.notifications.RentPaymentNotification;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.ClaimShopTrade;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.shop.ClaimShopMenu;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.trader_storage.ClaimGroupSettingsTab;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.trader_storage.ClaimMapTab;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.trader_storage.ClaimRentTab;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.trader_storage.ClaimTradeEditTab;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.settings.ClaimGroupSettings;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.settings.ClaimTradeSettings;
import io.github.lightman314.lightmanscompat.ftbchunks.core.FTBChunksBlocks;
import io.github.lightman314.lightmanscompat.ftbchunks.util.FTBChunksHelper;
import io.github.lightman314.lightmanscompat.ftbchunks.util.FTBTeamHelper;
import io.github.lightman314.lightmanscurrency.api.misc.IEasyTickable;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.misc.world.WorldPosition;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsNode;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderType;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.api.traders.permissions.PermissionOption;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ClaimShopData
extends TraderData
implements IEasyTickable,
IGroupableClaimTrader {
    public static final int CLAIM_RANGE = 3;
    public static final long MIN_RENT_DURATION = 3600000L;
    public static final long MAX_RENT_DURATION = 2592000000L;
    public static final TraderType<ClaimShopData> TYPE = new TraderType(VersionUtil.modResource((String)"lcompat", (String)"ftb_claim_shop"), ClaimShopData::new);
    private final ClaimShopTrade trade = new ClaimShopTrade(this);
    private boolean active = false;
    private MoneyValue price = MoneyValue.empty();
    private final Set<ChunkPos> chunkTargets = new HashSet<ChunkPos>();
    private PlayerReference customer = null;
    private boolean rentMode = false;
    private long rentStartTime = 0L;
    private long rentDuration = 0L;
    private boolean rentWarningGiven = false;
    private long rentDueWarning = 0L;
    private int prepaidCount = 0;
    private int maxRentPayments = 30;
    @Nullable
    private PlayerReference renter = null;
    private String groupName = "";
    private int groupLimit = 0;

    private ClaimShopData() {
        super(TYPE);
    }

    public ClaimShopData(Level level, BlockPos pos) {
        super(TYPE, level, pos);
        this.chunkTargets.add(new ChunkPos(pos));
    }

    public void PickupTrader(Player player, boolean adminState) {
        if (this.isActive() || this.isLocked()) {
            return;
        }
        super.PickupTrader(player, adminState);
    }

    protected void registerNodes(Consumer<SettingsNode> builder) {
        super.registerNodes(builder);
        builder.accept((SettingsNode)new ClaimTradeSettings(this));
        builder.accept((SettingsNode)new ClaimGroupSettings(this));
    }

    public IconData getIcon() {
        return IconData.of(FTBChunksBlocks.CLAIM_SHOP);
    }

    protected boolean allowAdditionalUpgradeType(UpgradeType upgradeType) {
        return false;
    }

    public boolean canShowOnTerminal() {
        return false;
    }

    public boolean hasBeenPurchased() {
        return this.customer != null;
    }

    @Override
    @Nullable
    public PlayerReference getCustomer() {
        if (this.isCurrentlyRented()) {
            return this.renter;
        }
        return this.customer;
    }

    public boolean canBeActivated() {
        if (this.price.isValidPrice() && this.areClaimsValid()) {
            return !this.rentMode || this.rentDuration >= 3600000L;
        }
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (active == this.active) {
            return;
        }
        if (active && !this.canBeActivated()) {
            return;
        }
        this.active = active;
        this.markDirty(new Consumer[]{this::saveActiveState});
        this.updateBlockState();
    }

    public MoneyValue getPrice() {
        return this.price;
    }

    public void setPrice(MoneyValue price) {
        this.price = price;
        this.markDirty(new Consumer[]{this::savePrice});
    }

    public boolean isRentMode() {
        return this.rentMode;
    }

    public void setRentMode(boolean rentMode) {
        if (this.rentMode == rentMode || this.active || this.isLocked()) {
            return;
        }
        this.rentMode = rentMode;
        this.markDirty(new Consumer[]{this::saveRentDataPacket});
    }

    public Set<ChunkPos> getChunkTargets() {
        return ImmutableSet.copyOf(this.chunkTargets);
    }

    public void overrideChunkTargets(Set<ChunkPos> chunks) {
        this.chunkTargets.clear();
        this.chunkTargets.addAll(chunks);
        this.validateChunkSelections();
        this.markDirty(new Consumer[]{this::saveChunks});
    }

    public void addChunkTarget(ChunkPos chunk) {
        if (this.isLocked() || ClaimShopData.isChunkOutOfRange(new ChunkPos(this.getWorldPosition().getPos()), chunk) || this.chunkTargets.contains(chunk)) {
            return;
        }
        this.chunkTargets.add(chunk);
        this.markDirty(new Consumer[]{this::saveChunks});
    }

    public void removeChunkTarget(ChunkPos chunk) {
        if (!this.chunkTargets.contains(chunk) || this.isLocked()) {
            return;
        }
        this.chunkTargets.remove(chunk);
        this.markDirty(new Consumer[]{this::saveChunks});
    }

    public int getPrepaidCount() {
        return this.prepaidCount;
    }

    public int getMaxRentPayments() {
        return this.maxRentPayments;
    }

    public void setMaxRentPayments(int newLimit) {
        if (this.maxRentPayments == newLimit) {
            return;
        }
        this.maxRentPayments = MathUtil.clamp((int)newLimit, (int)1, (int)99);
        this.markDirty(new Consumer[]{this::saveRentDataPacket});
    }

    public long getRentDuration() {
        return this.rentDuration;
    }

    public void setRentDuration(long newDuration) {
        if (this.rentDuration == newDuration || this.isLocked()) {
            return;
        }
        this.rentDuration = Math.min(newDuration, 2592000000L);
        this.markDirty(new Consumer[]{this::saveRentDataPacket});
    }

    public long getRentDueWarning() {
        return this.rentDueWarning;
    }

    public void setRentDueWarning(long newDuration) {
        if (this.rentDueWarning == newDuration) {
            return;
        }
        this.rentDueWarning = newDuration;
        this.markDirty(new Consumer[]{this::saveRentDataPacket});
    }

    public boolean getRentWarningGiven() {
        return this.rentWarningGiven;
    }

    public void clearRentWarningGiven() {
        if (!this.rentWarningGiven) {
            return;
        }
        this.rentWarningGiven = false;
        this.markDirty(new Consumer[]{this::saveRentDataPacket});
    }

    @Override
    public String getClaimGroup() {
        return this.groupName;
    }

    public void setClaimGroup(String groupName) {
        if (groupName.length() > 16) {
            groupName = groupName.substring(0, 16);
        }
        if (groupName.equals(this.groupName)) {
            return;
        }
        String oldGroup = this.groupName;
        this.groupName = groupName;
        ClaimGroupData.updateCache(this, oldGroup);
        this.markDirty(new Consumer[]{this::saveGroupData});
    }

    public int getGroupLimit() {
        return this.groupName.isBlank() ? 0 : this.groupLimit;
    }

    public boolean exceedsGroupLimit(PlayerReference player) {
        return !this.groupName.isBlank() && this.groupLimit > 0 && ClaimGroupData.getCountForGroup(this, player) >= this.groupLimit;
    }

    public void setGroupLimit(int groupLimit) {
        if (this.groupLimit == groupLimit) {
            return;
        }
        this.groupLimit = Math.max(0, groupLimit);
        this.markDirty(new Consumer[]{this::saveGroupData});
    }

    public int getTradeCount() {
        return 1;
    }

    public int getTradeStock(int tradeIndex) {
        return this.active ? 1 : 0;
    }

    public boolean isLocked() {
        return this.hasBeenPurchased() || this.isCurrentlyRented();
    }

    public boolean isCurrentlyRented() {
        return this.renter != null && (this.prepaidCount > 0 || !this.rentTimerExpired());
    }

    private boolean rentTimerExpired() {
        if (this.renter != null) {
            return !TimeUtil.compareTime((long)this.rentDuration, (long)this.rentStartTime);
        }
        return false;
    }

    public long rentTimeRemaining() {
        if (this.isCurrentlyRented()) {
            long totalDuration = this.rentDuration + (long)this.prepaidCount * this.rentDuration;
            return Math.max(0L, totalDuration + this.rentStartTime - TimeUtil.getCurrentTime());
        }
        return 0L;
    }

    public boolean canEndRental(Player player) {
        if (!this.isRentMode() || this.renter == null) {
            return false;
        }
        return LCAdminMode.isAdminPlayer((Player)player) || FTBTeamHelper.isOnSameTeam(this.renter, PlayerReference.of((Player)player), this.isClient());
    }

    public void tryEndRental(Player player) {
        if (this.isClient() || !this.canEndRental(player)) {
            return;
        }
        this.onRentExpired();
        this.markDirty(new Consumer[]{this::saveRentDataPacket});
    }

    public PlayerReference getIntendedLandOwner() {
        if (this.isCurrentlyRented()) {
            assert (this.renter != null);
            return this.renter;
        }
        return this.getOwner().getValidOwner().asPlayerReference();
    }

    public boolean areClaimsValid() {
        if (this.chunkTargets.isEmpty() || this.hasBeenPurchased()) {
            return false;
        }
        PlayerReference intendedOwner = this.getIntendedLandOwner();
        ResourceKey level = this.getWorldPosition().getDimension();
        if (level == null) {
            return false;
        }
        ChunkPos centerPos = new ChunkPos(this.getPos());
        for (ChunkPos pos : this.chunkTargets) {
            if (!ClaimShopData.isChunkOutOfRange(centerPos, pos) && FTBChunksHelper.isChunkOwner(intendedOwner, (ResourceKey<Level>)this.getWorldPosition().getDimension(), pos, this.isClient())) continue;
            return false;
        }
        return true;
    }

    public List<Pair<ResourceKey<Level>, ChunkPos>> getLockedClaims() {
        ArrayList<Pair<ResourceKey<Level>, ChunkPos>> results = new ArrayList<Pair<ResourceKey<Level>, ChunkPos>>();
        if (this.active || this.isCurrentlyRented()) {
            ResourceKey level = this.getWorldPosition().getDimension();
            if (level == null) {
                return results;
            }
            for (ChunkPos pos : this.chunkTargets) {
                results.add((Pair<ResourceKey<Level>, ChunkPos>)Pair.of((Object)level, (Object)pos));
            }
        }
        return results;
    }

    public static boolean isChunkLocked(ResourceKey<Level> level, ChunkPos pos) {
        return TraderAPI.API.GetAllTraders(false).stream().anyMatch(t -> {
            if (t instanceof ClaimShopData) {
                ClaimShopData shop = (ClaimShopData)t;
                return shop.getLockedClaims().stream().anyMatch(pair -> ((ResourceKey)pair.getFirst()).m_135782_().equals((Object)level.m_135782_()) && ((ChunkPos)pair.getSecond()).equals((Object)pos));
            }
            return false;
        });
    }

    public void reclaimLand(PlayerReference intendedOwner, @Nullable PlayerReference oldOwner) {
        if (this.isClient()) {
            return;
        }
        ResourceKey level = this.getWorldPosition().getDimension();
        if (level == null) {
            return;
        }
        for (ChunkPos pos : this.chunkTargets) {
            if (FTBChunksHelper.tryClaimChunk(intendedOwner, (ResourceKey<Level>)level, pos, oldOwner)) continue;
            this.active = false;
        }
        if (!this.active) {
            this.markDirty(new Consumer[]{this::saveActiveState});
            this.updateBlockState();
        }
    }

    protected void saveAdditional(CompoundTag tag) {
        this.saveActiveState(tag);
        this.savePrice(tag);
        this.saveChunks(tag);
        this.saveCustomer(tag);
        this.saveRentData(tag);
        this.saveGroupData(tag);
    }

    protected void saveActiveState(CompoundTag tag) {
        tag.m_128379_("Active", this.active);
    }

    protected void saveCustomer(CompoundTag tag) {
        if (this.customer != null) {
            tag.m_128365_("Customer", (Tag)this.customer.save());
        }
    }

    protected void savePrice(CompoundTag tag) {
        tag.m_128365_("Price", (Tag)this.price.save());
    }

    protected void saveTrades(CompoundTag tag) {
    }

    protected void saveChunks(CompoundTag tag) {
        ListTag list = new ListTag();
        for (ChunkPos pos : new ArrayList<ChunkPos>(this.chunkTargets)) {
            list.add((Object)LongTag.m_128882_((long)pos.m_45588_()));
        }
        tag.m_128365_("Chunks", (Tag)list);
    }

    protected void saveRentData(CompoundTag tag) {
        tag.m_128379_("RentMode", this.rentMode);
        tag.m_128356_("RentDuration", this.rentDuration);
        tag.m_128356_("RentDueWarning", this.rentDueWarning);
        tag.m_128379_("RentWarningGiven", this.rentWarningGiven);
        tag.m_128405_("PrepaidRent", this.prepaidCount);
        tag.m_128405_("MaxRentPayments", this.maxRentPayments);
        tag.m_128356_("RentStart", this.rentStartTime);
        if (this.renter != null) {
            tag.m_128365_("Renter", (Tag)this.renter.save());
        }
    }

    protected void saveRentDataPacket(CompoundTag tag) {
        this.saveRentData(tag);
        if (this.renter == null) {
            tag.m_128379_("NoRenter", true);
        }
    }

    protected void saveGroupData(CompoundTag tag) {
        tag.m_128359_("ClaimGroup", this.groupName);
        tag.m_128405_("GroupLimit", this.groupLimit);
    }

    protected void saveAdditionalToJson(JsonObject jsonObject) {
    }

    protected void loadAdditional(CompoundTag tag) {
        if (tag.m_128441_("Active")) {
            this.active = tag.m_128471_("Active");
        }
        if (tag.m_128441_("Price")) {
            this.price = MoneyValue.load((CompoundTag)tag.m_128469_("Price"));
        }
        if (tag.m_128441_("Chunks")) {
            this.chunkTargets.clear();
            ListTag list = tag.m_128437_("Chunks", 4);
            for (Tag value : list) {
                if (!(value instanceof NumericTag)) continue;
                NumericTag e = (NumericTag)value;
                this.chunkTargets.add(new ChunkPos(e.m_7046_()));
            }
        }
        if (tag.m_128441_("Customer")) {
            this.customer = PlayerReference.load((CompoundTag)tag.m_128469_("Customer"));
        }
        if (tag.m_128441_("RentMode")) {
            this.rentMode = tag.m_128471_("RentMode");
        }
        if (tag.m_128441_("RentDuration")) {
            this.rentDuration = tag.m_128454_("RentDuration");
        }
        if (tag.m_128441_("RentDueWarning")) {
            this.rentDueWarning = tag.m_128454_("RentDueWarning");
        }
        if (tag.m_128441_("RentWarningGiven")) {
            this.rentWarningGiven = tag.m_128471_("RentWarningGiven");
        }
        if (tag.m_128441_("PrepaidRent")) {
            this.prepaidCount = tag.m_128451_("PrepaidRent");
        }
        if (tag.m_128441_("MaxRentPayments")) {
            this.maxRentPayments = MathUtil.clamp((int)tag.m_128451_("MaxRentPayments"), (int)1, (int)99);
        }
        if (tag.m_128441_("RentStart")) {
            this.rentStartTime = tag.m_128454_("RentStart");
        }
        if (tag.m_128441_("Renter")) {
            this.renter = PlayerReference.load((CompoundTag)tag.m_128469_("Renter"));
        } else if (tag.m_128441_("NoRenter")) {
            this.renter = null;
        }
        if (tag.m_128441_("ClaimGroup")) {
            this.setClaimGroup(tag.m_128461_("ClaimGroup"));
        }
        if (tag.m_128441_("GroupLimit")) {
            this.groupLimit = tag.m_128451_("GroupLimit");
        }
    }

    public void OnRegisteredToOffice() {
        ClaimGroupData.updateCache(this, null);
    }

    protected void loadAdditionalFromJson(JsonObject jsonObject) throws JsonSyntaxException, ResourceLocationException {
    }

    protected void saveAdditionalPersistentData(CompoundTag compoundTag) {
    }

    protected void loadAdditionalPersistentData(CompoundTag compoundTag) {
    }

    protected void getAdditionalContents(List<ItemStack> list) {
    }

    public List<? extends TradeData> getTradeData() {
        return Lists.newArrayList((Object[])new ClaimShopTrade[]{this.trade});
    }

    public ClaimShopTrade getTrade() {
        return this.trade;
    }

    @Nullable
    public TradeData getTrade(int i) {
        return i == 0 ? this.trade : null;
    }

    public void addTrade(Player player) {
    }

    public void removeTrade(Player player) {
    }

    protected TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        MoneyValue price;
        if (tradeIndex != 0) {
            return TradeResult.FAIL_INVALID_TRADE;
        }
        ResourceKey level = this.getWorldPosition().getDimension();
        if (level == null) {
            return TradeResult.FAIL_INVALID_TRADE;
        }
        if (!this.price.isValidPrice() || !this.active) {
            return TradeResult.FAIL_OUT_OF_STOCK;
        }
        if (this.runPreTradeEvent(this.trade, context).isCanceled()) {
            return TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        PlayerReference owner = this.getOwner().getValidOwner().asPlayerReference();
        if (!this.areClaimsValid()) {
            return TradeResult.FAIL_INVALID_TRADE;
        }
        if (this.isCurrentlyRented()) {
            assert (this.renter != null);
            if (!FTBTeamHelper.isOnSameTeam(this.renter, context.getPlayerReference(), false)) {
                return TradeResult.FAIL_INVALID_TRADE;
            }
            if (this.prepaidCount >= this.maxRentPayments) {
                return TradeResult.FAIL_OUT_OF_STOCK;
            }
        } else if (!FTBChunksHelper.canClaimChunks(context.getPlayerReference(), (ResourceKey<Level>)level, this.chunkTargets, owner)) {
            return TradeResult.FAIL_NO_OUTPUT_SPACE;
        }
        if (!context.getPayment(price = this.runTradeCostEvent(this.trade, context).getCostResult())) {
            return TradeResult.FAIL_CANNOT_AFFORD;
        }
        MoneyValue taxesPaid = this.addStoredMoney(price, true);
        if (this.rentMode) {
            if (this.isCurrentlyRented()) {
                ++this.prepaidCount;
                this.markDirty(new Consumer[]{this::saveRentDataPacket});
            } else {
                this.rentStartTime = TimeUtil.getCurrentTime();
                this.renter = context.getPlayerReference();
                this.reclaimLand(this.renter, owner);
                this.updateBlockState();
            }
            if (this.rentTimeRemaining() >= this.rentDueWarning) {
                this.rentWarningGiven = false;
            }
            this.pushNotification(RentPaymentNotification.of(context.getPlayerReference(), price, taxesPaid, this.rentTimeRemaining(), this.getNotificationCategory()));
            this.markDirty(new Consumer[]{this::saveRentDataPacket});
        } else {
            this.customer = context.getPlayerReference();
            this.reclaimLand(context.getPlayerReference(), owner);
            this.pushNotification(LandPurchaseNotification.of(context.getPlayerReference(), price, taxesPaid, this.getNotificationCategory()));
            this.markDirty(new Consumer[]{this::saveActiveState});
        }
        this.runPostTradeEvent(this.trade, context, price, taxesPaid);
        this.updateBlockState();
        return TradeResult.SUCCESS;
    }

    public void handleSettingsChange(Player player, LazyPacketData message) {
        super.handleSettingsChange(player, message);
        if ((message.contains("ChangePlayerOwner") || message.contains("ChangeOwner")) && this.hasPermission(player, "transferOwnership") && !this.areClaimsValid()) {
            this.setActive(false);
        }
    }

    public boolean canMakePersistent() {
        return false;
    }

    public void initStorageTabs(ITraderStorageMenu menu) {
        menu.setTab(0, (TraderStorageTab)new ClaimTradeEditTab(menu));
        menu.setTab(1, (TraderStorageTab)new ClaimRentTab(menu));
        menu.setTab(2, (TraderStorageTab)new ClaimMapTab(menu));
        menu.setTab(3, (TraderStorageTab)new ClaimGroupSettingsTab(menu));
    }

    protected void addPermissionOptions(List<PermissionOption> list) {
    }

    public void tick() {
        if (this.isClient()) {
            return;
        }
        if (this.renter != null) {
            boolean changed = false;
            long timeRemaining = this.rentTimeRemaining();
            if (!this.rentWarningGiven && timeRemaining > 0L && timeRemaining < this.rentDueWarning) {
                this.rentWarningGiven = true;
                FTBTeamHelper.pushNotificationToRenter(this.renter, RentDueNotification.of(timeRemaining, this.getNotificationCategory()));
                changed = true;
            }
            while (this.rentTimerExpired()) {
                if (this.prepaidCount > 0) {
                    --this.prepaidCount;
                    this.rentStartTime += this.rentDuration;
                    changed = true;
                    continue;
                }
                this.onRentExpired();
                changed = true;
                break;
            }
            if (changed) {
                this.markDirty(new Consumer[]{this::saveRentDataPacket});
            }
        }
    }

    protected void onRentExpired() {
        this.reclaimLand(this.getOwner().getValidOwner().asPlayerReference(), this.renter);
        if (this.renter != null) {
            this.pushNotification(RentExpiredNotification.of(this.renter, this.getNotificationCategory()));
        }
        this.renter = null;
        this.prepaidCount = 0;
        this.rentStartTime = 0L;
        this.validateChunkSelections();
        this.updateBlockState();
    }

    protected MenuProvider getTraderMenuProvider(MenuValidator validator) {
        return new ShopMenuProvider(this.getID(), validator);
    }

    public void move(Level level, BlockPos pos) {
        super.move(level, pos);
        this.validateChunkSelections();
    }

    public void OnTraderMoved(WorldPosition newPosition) {
        super.OnTraderMoved(newPosition);
        this.validateChunkSelections();
    }

    public static boolean isChunkOutOfRange(ChunkPos center, ChunkPos test) {
        return Math.abs(test.f_45578_ - center.f_45578_) > 3 || Math.abs(test.f_45579_ - center.f_45579_) > 3;
    }

    private void validateChunkSelections() {
        if (this.isCurrentlyRented()) {
            if (!this.active) {
                return;
            }
            ChunkPos centerPos = new ChunkPos(this.getPos());
            if (this.chunkTargets.stream().anyMatch(pos -> ClaimShopData.isChunkOutOfRange(centerPos, pos))) {
                this.active = false;
                this.markDirty(new Consumer[]{this::saveActiveState});
            }
            return;
        }
        ChunkPos centerPos = new ChunkPos(this.getPos());
        int startCount = this.chunkTargets.size();
        this.chunkTargets.removeIf(pos -> ClaimShopData.isChunkOutOfRange(centerPos, pos));
        if (this.chunkTargets.size() != startCount) {
            this.markDirty(new Consumer[]{this::saveChunks});
        }
        if (this.chunkTargets.isEmpty() && this.active) {
            this.active = false;
            this.markDirty(new Consumer[]{this::saveActiveState});
        }
    }

    public void updateBlockState() {
        TraderBlockEntity be = this.getBlockEntity();
        if (be == null) {
            return;
        }
        Level level = be.m_58904_();
        BlockPos pos = be.m_58899_();
        BlockState state = be.m_58900_();
        if (level != null && state.m_61138_(ClaimShopState.PROPERTY)) {
            ClaimShopState newState = ClaimShopState.INACTIVE;
            if (this.isCurrentlyRented()) {
                newState = ClaimShopState.RENTED;
            } else if (this.hasBeenPurchased()) {
                newState = ClaimShopState.SOLD;
            } else if (this.isActive()) {
                newState = this.isRentMode() ? ClaimShopState.FOR_RENT : ClaimShopState.FOR_SALE;
            }
            level.m_46597_(pos, (BlockState)state.m_61124_(ClaimShopState.PROPERTY, (Comparable)((Object)newState)));
        }
    }

    private record ShopMenuProvider(long traderID, MenuValidator validator) implements EasyMenuProvider
    {
        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new ClaimShopMenu(id, inventory, this.traderID, this.validator);
        }
    }
}

