/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.notifications;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscompat.ftbchunks.FTBChunksText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.TaxableNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class RentPaymentNotification
extends TaxableNotification {
    public static final NotificationType<RentPaymentNotification> TYPE = new NotificationType(VersionUtil.modResource((String)"lcompat", (String)"ftb_rent_payment"), RentPaymentNotification::new);
    private PlayerReference player;
    private MoneyValue price;
    private long timeRemaining;
    private TraderCategory category;

    private RentPaymentNotification() {
    }

    protected RentPaymentNotification(PlayerReference player, MoneyValue price, MoneyValue taxesPaid, long timeRemaining, TraderCategory category) {
        super(taxesPaid);
        this.player = player;
        this.price = price;
        this.timeRemaining = timeRemaining;
        this.category = category;
    }

    public static Supplier<Notification> of(PlayerReference player, MoneyValue price, MoneyValue taxesPaid, long timeRemaining, TraderCategory category) {
        return () -> new RentPaymentNotification(player, price, taxesPaid, timeRemaining, category);
    }

    protected List<MutableComponent> getNormalMessageLines() {
        String timeRemainingText = new TimeUtil.TimeData(this.timeRemaining).getString();
        return Lists.newArrayList((Object[])new MutableComponent[]{FTBChunksText.NOTIFICATION_RENT_PAYMENT_1.get(new Object[]{this.player.getName(this.isClient()), this.price, timeRemainingText}), FTBChunksText.NOTIFICATION_RENT_PAYMENT_2.get(new Object[]{this.player.getName(this.isClient()), this.price, timeRemainingText})});
    }

    protected NotificationType<?> getType() {
        return TYPE;
    }

    public NotificationCategory getCategory() {
        return this.category;
    }

    protected void saveNormal(CompoundTag tag) {
        tag.m_128365_("Player", (Tag)this.player.save());
        tag.m_128365_("Price", (Tag)this.price.save());
        tag.m_128356_("TimeRemaining", this.timeRemaining);
        tag.m_128365_("Trader", (Tag)this.category.save());
    }

    protected void loadNormal(CompoundTag tag) {
        this.player = PlayerReference.load((CompoundTag)tag.m_128469_("Player"));
        this.price = MoneyValue.load((CompoundTag)tag.m_128469_("Price"));
        this.timeRemaining = tag.m_128454_("TimeRemaining");
        this.category = new TraderCategory(tag.m_128469_("Trader"));
    }

    protected boolean canMerge(Notification notification) {
        return false;
    }
}

