/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.core;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class LCompatRegistries {
    private static IEventBus modBus = null;
    private static final Map<ResourceLocation, DeferredRegister<?>> REGISTRIES = new HashMap();

    public static DeferredRegister<Item> ItemRegistry() {
        return LCompatRegistries.getRegistry(ForgeRegistries.ITEMS);
    }

    public static DeferredRegister<Block> BlockRegistry() {
        return LCompatRegistries.getRegistry(ForgeRegistries.BLOCKS);
    }

    public static DeferredRegister<BlockEntityType<?>> BlockEntityRegistry() {
        return LCompatRegistries.getRegistry(ForgeRegistries.BLOCK_ENTITY_TYPES);
    }

    public static <T> DeferredRegister<T> getRegistry(IForgeRegistry<T> registry) {
        return LCompatRegistries.getRegistry(registry.getRegistryKey());
    }

    public static <T> DeferredRegister<T> getRegistry(ResourceKey<? extends Registry<T>> key) {
        ResourceLocation id = key.m_135782_();
        if (!REGISTRIES.containsKey(id)) {
            DeferredRegister registry = DeferredRegister.create(key, (String)"lcompat");
            REGISTRIES.put(id, registry);
            if (modBus != null) {
                registry.register(modBus);
            }
        }
        try {
            return REGISTRIES.get(id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void init(IEventBus eventBus) {
        modBus = eventBus;
        for (DeferredRegister<?> registry : REGISTRIES.values()) {
            registry.register(modBus);
        }
    }
}

