/*
 * Decompiled with CFR 0.152.
 */
package vice.sol_valheim.mixin;

import java.util.function.BooleanSupplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vice.sol_valheim.SOLValheim;
import vice.sol_valheim.ValheimFoodData;
import vice.sol_valheim.accessors.PlayerEntityMixinDataAccessor;

@Mixin(value={ServerLevel.class})
public class ServerLevelMixin {
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setDayTime(J)V")}, method={"tick"})
    public void onSleep(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        if (!SOLValheim.Config.common.passTicksDuringNight) {
            return;
        }
        ServerLevel level = (ServerLevel)this;
        long dayTime = level.m_6106_().m_6792_();
        long l = dayTime + 24000L;
        long newTime = l - l % 24000L;
        long passedTicks = Math.max(0L, newTime - dayTime);
        if (passedTicks == 0L) {
            return;
        }
        for (ServerPlayer player : level.m_6907_()) {
            ValheimFoodData foodData = ((PlayerEntityMixinDataAccessor)player).sol_valheim$getFoodData();
            if (foodData.DrinkSlot != null) {
                foodData.DrinkSlot.ticksLeft = (int)Math.max(1200L, (long)foodData.DrinkSlot.ticksLeft - passedTicks);
            }
            for (ValheimFoodData.EatenFoodItem item : foodData.ItemEntries) {
                item.ticksLeft = (int)Math.max(1200L, (long)item.ticksLeft - passedTicks);
            }
        }
    }
}

