/*
 * Decompiled with CFR 0.152.
 */
package vice.sol_valheim.mixin;

import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vice.sol_valheim.ModConfig;
import vice.sol_valheim.SOLValheim;
import vice.sol_valheim.ValheimFoodData;
import vice.sol_valheim.accessors.FoodDataPlayerAccessor;
import vice.sol_valheim.accessors.PlayerEntityMixinDataAccessor;
import vice.sol_valheim.mixin.LivingEntityDamageAccessor;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements PlayerEntityMixinDataAccessor {
    @Unique
    private static final EntityDataAccessor<ValheimFoodData> sol_valheim$DATA_ACCESSOR = SynchedEntityData.m_135353_(Player.class, ValheimFoodData.FOOD_DATA_SERIALIZER);
    @Shadow
    protected FoodData f_36097_;
    @Unique
    private ValheimFoodData sol_valheim$food_data = new ValheimFoodData();

    @Override
    @Unique
    public ValheimFoodData sol_valheim$getFoodData() {
        Player player = (Player)this;
        return (ValheimFoodData)player.m_20088_().m_135370_(sol_valheim$DATA_ACCESSOR);
    }

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"causeFoodExhaustion(F)V"}, cancellable=true)
    private void onAddExhaustion(float exhaustion, CallbackInfo info) {
        info.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"getFoodData"})
    private void onGetFoodData(CallbackInfoReturnable<FoodData> cir) {
        ((FoodDataPlayerAccessor)this.f_36097_).sol_valheim$setPlayer((Player)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"})
    private void onEatFood(Level world, ItemStack stack, CallbackInfoReturnable<ItemStack> info) {
        if (stack.m_41720_() == Items.f_42583_) {
            this.sol_valheim$food_data.clear();
            this.sol_valheim$trackData();
            return;
        }
        this.sol_valheim$food_data.eatItem(stack.m_41720_());
        this.sol_valheim$trackData();
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void onTick(CallbackInfo info) {
        this.sol_valheim$tick();
    }

    @Unique
    private void sol_valheim$tick() {
        long timeSinceHurt;
        Level level = this.m_9236_();
        if (level.f_46443_) {
            return;
        }
        if (this.m_21224_()) {
            this.sol_valheim$food_data.clear();
            this.sol_valheim$trackData();
            return;
        }
        if (!this.sol_valheim$food_data.ItemEntries.isEmpty()) {
            this.sol_valheim$food_data.tick();
            this.sol_valheim$trackData();
            Player player = (Player)this;
            if (player.f_19797_ % 20 == 0) {
                ModConfig.Common.FoodConfig config;
                for (ValheimFoodData.EatenFoodItem eaten : this.sol_valheim$food_data.ItemEntries) {
                    ModConfig.Common.FoodConfig config2 = ModConfig.getFoodConfig(eaten.item);
                    if (config2 == null) continue;
                    this.sol_valheim$applyFoodEffectsToPlayer(player, eaten, config2);
                }
                if (this.sol_valheim$food_data.DrinkSlot != null && (config = ModConfig.getFoodConfig(this.sol_valheim$food_data.DrinkSlot.item)) != null) {
                    this.sol_valheim$applyFoodEffectsToPlayer(player, this.sol_valheim$food_data.DrinkSlot, config);
                }
            }
        }
        float maxhp = Math.min((float)(SOLValheim.Config.common.maxFoodHealth * 2), (float)(SOLValheim.Config.common.startingHealth * 2) + this.sol_valheim$food_data.getTotalFoodNutrition());
        maxhp = Math.round(maxhp / 2.0f) * 2;
        Player player = (Player)this;
        player.m_36324_().m_38717_(0.0f);
        player.m_21051_(Attributes.f_22276_).m_22100_((double)maxhp);
        if (SOLValheim.Config.common.speedBoost > 0.01f) {
            AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
            AttributeModifier speedBuff = attr.m_22111_(SOLValheim.getSpeedBuffModifier().m_22209_());
            if (maxhp >= 20.0f && speedBuff == null) {
                attr.m_22118_(SOLValheim.getSpeedBuffModifier());
            } else if (maxhp < 20.0f && speedBuff != null) {
                attr.m_22130_(SOLValheim.getSpeedBuffModifier());
            }
        }
        if ((timeSinceHurt = level.m_46467_() - ((LivingEntityDamageAccessor)((Object)this)).getLastDamageStamp()) > (long)SOLValheim.Config.common.regenDelay && (float)player.f_19797_ % (5.0f * SOLValheim.Config.common.regenSpeedModifier) == 0.0f) {
            player.m_5634_(this.sol_valheim$food_data.getRegenSpeed() / 20.0f);
        }
    }

    @Unique
    private void sol_valheim$applyFoodEffectsToPlayer(Player player, ValheimFoodData.EatenFoodItem eatenData, ModConfig.Common.FoodConfig config) {
        int ticksLeft = eatenData.ticksLeft;
        for (ModConfig.Common.MobEffectConfig effectCfg : config.extraEffects) {
            int threshold;
            MobEffect mobEffect = effectCfg.getEffect();
            if (mobEffect == null) continue;
            int amplifier = Math.max(effectCfg.amplifier - 1, 0);
            float fractionActive = effectCfg.duration;
            int totalTime = config.getTime();
            if (ticksLeft >= totalTime - (threshold = (int)((float)totalTime * fractionActive))) {
                player.m_7292_(new MobEffectInstance(mobEffect, 120, amplifier, false, false));
                continue;
            }
            player.m_21195_(mobEffect);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canEat(Z)Z"}, cancellable=true)
    private void onCanConsume(boolean ignorehunger, CallbackInfoReturnable<Boolean> info) {
        info.setReturnValue((Object)true);
        info.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, cancellable=true)
    private void onDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> info) {
        if (source == this.m_269291_().m_269064_()) {
            info.setReturnValue((Object)Boolean.FALSE);
            info.cancel();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void onWriteCustomData(CompoundTag nbt, CallbackInfo info) {
        nbt.m_128365_("sol_food_data", (Tag)this.sol_valheim$food_data.save(new CompoundTag()));
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void onReadCustomData(CompoundTag nbt, CallbackInfo info) {
        if (this.sol_valheim$food_data == null) {
            this.sol_valheim$food_data = new ValheimFoodData();
        }
        ValheimFoodData foodData = ValheimFoodData.read(nbt.m_128469_("sol_food_data"));
        this.sol_valheim$food_data.MaxItemSlots = foodData.MaxItemSlots;
        this.sol_valheim$food_data.DrinkSlot = foodData.DrinkSlot;
        this.sol_valheim$food_data.ItemEntries = foodData.ItemEntries.stream().map(ValheimFoodData.EatenFoodItem::new).collect(Collectors.toCollection(ArrayList::new));
        this.sol_valheim$trackData();
    }

    @Unique
    private void sol_valheim$trackData() {
        this.f_19804_.m_276349_(sol_valheim$DATA_ACCESSOR, (Object)this.sol_valheim$food_data, true);
    }

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"})
    private void onInitDataTracker(CallbackInfo info) {
        if (this.sol_valheim$food_data == null) {
            this.sol_valheim$food_data = new ValheimFoodData();
        }
        this.f_19804_.m_135372_(sol_valheim$DATA_ACCESSOR, (Object)this.sol_valheim$food_data);
    }
}

