/*
 * Decompiled with CFR 0.152.
 */
package vice.sol_valheim;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import vice.sol_valheim.ModConfig;
import vice.sol_valheim.SOLValheim;

public class ValheimFoodData {
    public static final EntityDataSerializer<ValheimFoodData> FOOD_DATA_SERIALIZER = new EntityDataSerializer<ValheimFoodData>(){

        public void write(FriendlyByteBuf buffer, ValheimFoodData value) {
            buffer.m_130079_(value.save(new CompoundTag()));
        }

        public ValheimFoodData read(FriendlyByteBuf buffer) {
            return ValheimFoodData.read(buffer.m_130260_());
        }

        public ValheimFoodData copy(ValheimFoodData value) {
            ValheimFoodData ret = new ValheimFoodData();
            ret.MaxItemSlots = value.MaxItemSlots;
            ret.ItemEntries = value.ItemEntries.stream().map(EatenFoodItem::new).collect(Collectors.toCollection(ArrayList::new));
            if (value.DrinkSlot != null) {
                ret.DrinkSlot = new EatenFoodItem(value.DrinkSlot);
            }
            return ret;
        }
    };
    public List<EatenFoodItem> ItemEntries = new ArrayList<EatenFoodItem>();
    public EatenFoodItem DrinkSlot;
    public int MaxItemSlots;

    public ValheimFoodData() {
        this.MaxItemSlots = SOLValheim.Config.common.maxSlots;
    }

    public void eatItem(Item food) {
        boolean isDrink;
        if (food == Items.f_42583_) {
            return;
        }
        ModConfig.Common.FoodConfig config = ModConfig.getFoodConfig(food);
        if (config == null) {
            return;
        }
        boolean bl = isDrink = food.m_7968_().m_41780_() == UseAnim.DRINK;
        if (isDrink) {
            if (this.DrinkSlot != null && !this.DrinkSlot.canEatEarly()) {
                return;
            }
            if (this.DrinkSlot == null) {
                this.DrinkSlot = new EatenFoodItem(food, config.getTime());
            } else {
                this.DrinkSlot.ticksLeft = config.getTime();
                this.DrinkSlot.item = food;
            }
            return;
        }
        EatenFoodItem existing = this.getEatenFood(food);
        if (existing != null) {
            if (!existing.canEatEarly()) {
                return;
            }
            existing.ticksLeft = config.getTime();
            return;
        }
        if (this.ItemEntries.size() < this.MaxItemSlots) {
            this.ItemEntries.add(new EatenFoodItem(food, config.getTime()));
            return;
        }
        for (EatenFoodItem item : this.ItemEntries) {
            if (!item.canEatEarly()) continue;
            item.ticksLeft = config.getTime();
            item.item = food;
            return;
        }
    }

    public boolean canEat(Item food) {
        if (food == Items.f_42583_) {
            return true;
        }
        if (food.m_7968_().m_41780_() == UseAnim.DRINK) {
            return this.DrinkSlot == null || this.DrinkSlot.canEatEarly();
        }
        EatenFoodItem existing = this.getEatenFood(food);
        if (existing != null) {
            return existing.canEatEarly();
        }
        if (this.ItemEntries.size() < this.MaxItemSlots) {
            return true;
        }
        return this.ItemEntries.stream().anyMatch(EatenFoodItem::canEatEarly);
    }

    public EatenFoodItem getEatenFood(Item food) {
        return this.ItemEntries.stream().filter(item -> item.item == food).findFirst().orElse(null);
    }

    public void clear() {
        this.ItemEntries.clear();
        this.DrinkSlot = null;
    }

    public void tick() {
        for (EatenFoodItem item2 : this.ItemEntries) {
            --item2.ticksLeft;
        }
        if (this.DrinkSlot != null) {
            --this.DrinkSlot.ticksLeft;
            if (this.DrinkSlot.ticksLeft <= 0) {
                this.DrinkSlot = null;
            }
        }
        this.ItemEntries.removeIf(item -> item.ticksLeft <= 0);
        this.ItemEntries.sort(Comparator.comparingInt(a -> a.ticksLeft));
    }

    public float getTotalFoodNutrition() {
        float nutrition = 0.0f;
        for (EatenFoodItem item : this.ItemEntries) {
            ModConfig.Common.FoodConfig food = ModConfig.getFoodConfig(item.item);
            if (food == null) continue;
            nutrition += (float)food.getHearts();
        }
        if (this.DrinkSlot != null) {
            ModConfig.Common.FoodConfig food = ModConfig.getFoodConfig(this.DrinkSlot.item);
            if (food != null) {
                nutrition += (float)food.getHearts();
            }
            nutrition *= 1.0f + SOLValheim.Config.common.drinkSlotFoodEffectivenessBonus;
        }
        return nutrition;
    }

    public float getRegenSpeed() {
        float regen = 0.25f;
        for (EatenFoodItem item : this.ItemEntries) {
            ModConfig.Common.FoodConfig food = ModConfig.getFoodConfig(item.item);
            if (food == null) continue;
            regen += food.getHealthRegen();
        }
        if (this.DrinkSlot != null) {
            ModConfig.Common.FoodConfig food = ModConfig.getFoodConfig(this.DrinkSlot.item);
            if (food != null) {
                regen += food.getHealthRegen();
            }
            regen *= 1.0f + SOLValheim.Config.common.drinkSlotFoodEffectivenessBonus;
        }
        return regen;
    }

    public CompoundTag save(CompoundTag tag) {
        int count = 0;
        tag.m_128405_("max_slots", this.MaxItemSlots);
        tag.m_128405_("count", this.ItemEntries.size());
        for (EatenFoodItem item : this.ItemEntries) {
            tag.m_128359_("id" + count, item.item.arch$registryName().toString());
            tag.m_128405_("ticks" + count, item.ticksLeft);
            ++count;
        }
        if (this.DrinkSlot != null) {
            tag.m_128359_("drink", this.DrinkSlot.item.arch$registryName().toString());
            tag.m_128405_("drinkticks", this.DrinkSlot.ticksLeft);
        }
        return tag;
    }

    public static ValheimFoodData read(CompoundTag tag) {
        ValheimFoodData instance = new ValheimFoodData();
        instance.MaxItemSlots = tag.m_128451_("max_slots");
        int size = tag.m_128451_("count");
        for (int count = 0; count < size; ++count) {
            String str = tag.m_128461_("id" + count);
            int ticks = tag.m_128451_("ticks" + count);
            Item item = (Item)SOLValheim.ITEMS.getRegistrar().get(new ResourceLocation(str));
            instance.ItemEntries.add(new EatenFoodItem(item, ticks));
        }
        String drink = tag.m_128461_("drink");
        int drinkTicks = tag.m_128451_("drinkticks");
        if (!drink.isBlank()) {
            Item item = (Item)SOLValheim.ITEMS.getRegistrar().get(new ResourceLocation(drink));
            instance.DrinkSlot = new EatenFoodItem(item, drinkTicks);
        }
        return instance;
    }

    public static class EatenFoodItem {
        public Item item;
        public int ticksLeft;

        public boolean canEatEarly() {
            if (this.ticksLeft < 1200) {
                return true;
            }
            ModConfig.Common.FoodConfig config = ModConfig.getFoodConfig(this.item);
            if (config == null) {
                return false;
            }
            return (float)this.ticksLeft / (float)config.getTime() < SOLValheim.Config.common.eatAgainPercentage;
        }

        public EatenFoodItem(Item item, int ticksLeft) {
            this.item = item;
            this.ticksLeft = ticksLeft;
        }

        public EatenFoodItem(EatenFoodItem eaten) {
            this.item = eaten.item;
            this.ticksLeft = eaten.ticksLeft;
        }
    }
}

