/*
 * Decompiled with CFR 0.152.
 */
package vice.sol_valheim;

import dev.architectury.registry.registries.DeferredRegister;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import vice.sol_valheim.ModConfig;
import vice.sol_valheim.ValheimFoodData;

public class SOLValheim {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"sol_valheim", (ResourceKey)Registries.f_256913_);
    public static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"sol_valheim", (ResourceKey)Registries.f_256929_);
    public static ModConfig Config;
    public static final String MOD_ID = "sol_valheim";
    private static AttributeModifier speedBuff;

    public static AttributeModifier getSpeedBuffModifier() {
        if (speedBuff == null) {
            speedBuff = new AttributeModifier("sol_valheim_speed_buff", (double)SOLValheim.Config.common.speedBoost, AttributeModifier.Operation.MULTIPLY_BASE);
        }
        return speedBuff;
    }

    public static void init() {
        EntityDataSerializers.m_135050_(ValheimFoodData.FOOD_DATA_SERIALIZER);
        AutoConfig.register(ModConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        Config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        boolean addedAny = false;
        for (Item item : BuiltInRegistries.f_257033_) {
            ResourceLocation key = item.arch$registryName();
            ModConfig.Common.FoodConfig existing = SOLValheim.Config.common.foodConfigs.get(key);
            if (existing != null) continue;
            ModConfig.getFoodConfig(item);
            addedAny = true;
        }
        if (addedAny) {
            AutoConfig.getConfigHolder(ModConfig.class).save();
        }
    }

    public static void addTooltip(ItemStack item, TooltipFlag flag, List<Component> list) {
        Item food = item.m_41720_();
        if (food == Items.f_42583_) {
            list.add((Component)Component.m_237113_((String)"\u2620 Empties Your Stomach!").m_130940_(ChatFormatting.GREEN));
            return;
        }
        ModConfig.Common.FoodConfig config = ModConfig.getFoodConfig(food);
        if (config == null) {
            return;
        }
        Integer hearts = config.getHearts() % 2 == 0 ? Integer.valueOf(config.getHearts() / 2) : String.format("%.1f", Float.valueOf((float)config.getHearts() / 2.0f));
        list.add((Component)Component.m_237113_((String)("\u2764 " + String.valueOf(hearts) + " Heart" + ((float)config.getHearts() / 2.0f > 1.0f ? "s" : ""))).m_130940_(ChatFormatting.RED));
        list.add((Component)Component.m_237113_((String)("\u2600 " + String.format("%.1f", Float.valueOf(config.getHealthRegen())) + " Regen")).m_130940_(ChatFormatting.DARK_RED));
        float minutes = (float)config.getTime() / 1200.0f;
        list.add((Component)Component.m_237113_((String)("\u231a " + String.format("%.0f", Float.valueOf(minutes)) + " Minute" + (minutes > 1.0f ? "s" : ""))).m_130940_(ChatFormatting.GOLD));
        if (!config.extraEffects.isEmpty() && SOLValheim.Config.common.displayEffects) {
            list.add((Component)Component.m_237113_((String)""));
            for (ModConfig.Common.MobEffectConfig effect : config.extraEffects) {
                MobEffect eff = effect.getEffect();
                if (eff == null) continue;
                float effectDurationSeconds = (float)config.getTime() * effect.duration / 20.0f;
                int minutesPart = (int)(effectDurationSeconds / 60.0f);
                int secondsPart = (int)(effectDurationSeconds % 60.0f);
                if (eff.m_19486_()) {
                    list.add((Component)Component.m_237113_((String)("\u2605 " + eff.m_19482_().getString() + (String)(effect.amplifier > 1 ? " " + effect.amplifier : "") + String.format(" (%02d:%02d)", minutesPart, secondsPart))).m_130940_(ChatFormatting.GREEN));
                    continue;
                }
                list.add((Component)Component.m_237113_((String)("\u274c " + eff.m_19482_().getString() + (String)(effect.amplifier > 1 ? " " + effect.amplifier : "") + String.format(" (%02d:%02d)", minutesPart, secondsPart))).m_130940_(ChatFormatting.DARK_RED));
            }
        }
        if (item.m_41780_() == UseAnim.DRINK) {
            list.add((Component)Component.m_237113_((String)"\u2744 Refreshing!").m_130940_(ChatFormatting.AQUA));
        }
    }
}

