/*
 * Decompiled with CFR 0.152.
 */
package vice.sol_valheim;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import vice.sol_valheim.SOLValheim;

@Config(name="sol_valheim")
@Config.Gui.Background(value="minecraft:textures/block/stone.png")
public class ModConfig
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.TransitiveObject
    public Common common = new Common();
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.TransitiveObject
    public Client client = new Client();

    public static Common.FoodConfig getFoodConfig(Item item) {
        boolean isDrink;
        boolean bl = isDrink = item.m_7968_().m_41780_() == UseAnim.DRINK;
        if (item != Items.f_42502_ && !item.m_41472_() && !isDrink) {
            return null;
        }
        Common.FoodConfig existing = SOLValheim.Config.common.foodConfigs.get(item.arch$registryName().toString());
        if (existing == null) {
            FoodProperties food;
            String registry = item.arch$registryName().toString();
            FoodProperties foodProperties = food = item == Items.f_42502_ ? new FoodProperties.Builder().m_38760_(10).m_38758_(0.7f).m_38767_() : item.m_41473_();
            if (isDrink) {
                food = registry.contains("potion") ? new FoodProperties.Builder().m_38760_(4).m_38758_(0.75f).m_38767_() : (registry.contains("milk") ? new FoodProperties.Builder().m_38760_(6).m_38758_(1.0f).m_38767_() : new FoodProperties.Builder().m_38760_(2).m_38758_(0.5f).m_38767_());
            }
            existing = new Common.FoodConfig();
            existing.nutrition = food.m_38744_();
            existing.healthRegenModifier = 1.0f;
            existing.saturationModifier = food.m_38745_();
            if (registry.startsWith("farmers")) {
                existing.nutrition = (int)((double)existing.nutrition * 1.25);
                existing.saturationModifier *= 1.1f;
                existing.healthRegenModifier = 1.25f;
            }
            if (registry.equals("minecraft:golden_apple") || registry.equals("minecraft:enchanted_golden_apple")) {
                existing.nutrition = 10;
                existing.healthRegenModifier = 1.5f;
            }
            if (registry.equals("minecraft:beetroot_soup")) {
                Common.MobEffectConfig effectConfig = new Common.MobEffectConfig();
                effectConfig.ID = BuiltInRegistries.f_256974_.m_7981_((Object)MobEffects.f_19596_).toString();
                existing.extraEffects.add(effectConfig);
            }
            SOLValheim.Config.common.foodConfigs.put(item.arch$registryName().toString(), existing);
        }
        return existing;
    }

    @Config(name="common")
    public static final class Common
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Default time in seconds that food should last per saturation level")
        public int defaultTimer = 180;
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Speed at which regeneration should occur")
        public float regenSpeedModifier = 1.0f;
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Time in ticks that regeneration should wait after taking damage")
        public int regenDelay = 200;
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Time in seconds after spawning before sprinting is disabled")
        public int respawnGracePeriod = 300;
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Extra speed given when your hearts are full (0 to disable)")
        public float speedBoost = 0.2f;
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Maximum allowed hearts from food")
        public int maxFoodHealth = 100;
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Number of hearts to start with")
        public int startingHealth = 3;
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Number of food slots (range 2-5, default 3)")
        public int maxSlots = 3;
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Percentage remaining before you can eat again")
        public float eatAgainPercentage = 0.2f;
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Boost given to other foods when drinking")
        public float drinkSlotFoodEffectivenessBonus = 0.1f;
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Simulate food ticking down during night")
        public boolean passTicksDuringNight = true;
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Whether or not food tooltips should show extra effects")
        public boolean displayEffects = true;
        @ConfigEntry.Gui.Tooltip(count=5)
        @Comment(value="    Food nutrition and effect overrides (Auto Generated if Empty)\n    - nutrition: Affects Heart Gain & Health Regen\n    - saturationModifier: Affects Food Duration & Player Speed\n    - healthRegenModifier: Multiplies health regen speed\n    - extraEffects: Extra effects provided by eating the food. Format: { String ID, float duration, int amplifier }\n")
        public Map<String, FoodConfig> foodConfigs = new HashMap<String, FoodConfig>();

        public static final class MobEffectConfig
        implements ConfigData {
            @ConfigEntry.Gui.Tooltip
            @Comment(value="Mob Effect ID")
            public String ID;
            @ConfigEntry.Gui.Tooltip
            @Comment(value="Effect duration percentage (1f is the entire food duration)")
            public float duration = 1.0f;
            @ConfigEntry.Gui.Tooltip
            @Comment(value="Effect Level")
            public int amplifier = 1;

            public MobEffect getEffect() {
                return (MobEffect)SOLValheim.MOB_EFFECTS.getRegistrar().get(new ResourceLocation(this.ID));
            }
        }

        public static final class FoodConfig
        implements ConfigData {
            public int nutrition;
            public float saturationModifier = 1.0f;
            public float healthRegenModifier = 1.0f;
            public List<MobEffectConfig> extraEffects = new ArrayList<MobEffectConfig>();

            public int getTime() {
                int time = (int)((float)(SOLValheim.Config.common.defaultTimer * 20) * this.saturationModifier * (float)this.nutrition);
                return Math.max(time, 6000);
            }

            public int getHearts() {
                return Math.max(this.nutrition, 2);
            }

            public float getHealthRegen() {
                return Mth.m_14036_((float)((float)this.nutrition * 0.1f * this.healthRegenModifier), (float)0.25f, (float)2.0f);
            }
        }
    }

    @Config(name="client")
    public static final class Client
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Enlarge the currently eaten food icons")
        public boolean useLargeIcons = true;
        @Comment(value="Anchor point is the bottom left corner")
        public int x_offset = 200;
        public int y_offset = 1;
        public boolean rightToLeft = true;
    }
}

