/*
 * Decompiled with CFR 0.152.
 */
package vice.sol_valheim;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.platform.Platform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import vice.sol_valheim.ModConfig;
import vice.sol_valheim.SOLValheim;
import vice.sol_valheim.ValheimFoodData;
import vice.sol_valheim.accessors.PlayerEntityMixinDataAccessor;

public class FoodHUD
implements ClientGuiEvent.RenderHud {
    static Minecraft client;
    private static int HudHeight;

    public FoodHUD() {
        ClientGuiEvent.RENDER_HUD.register((Object)this);
        client = Minecraft.m_91087_();
    }

    public void renderHud(GuiGraphics graphics, float tickDelta) {
        if (FoodHUD.client.f_91074_ == null) {
            return;
        }
        PlayerEntityMixinDataAccessor solPlayer = (PlayerEntityMixinDataAccessor)FoodHUD.client.f_91074_;
        ValheimFoodData foodData = solPlayer.sol_valheim$getFoodData();
        if (foodData == null) {
            return;
        }
        boolean useLargeIcons = SOLValheim.Config.client.useLargeIcons;
        int width = SOLValheim.Config.client.x_offset;
        int height = client.m_91268_().m_85446_() - (useLargeIcons ? 18 : 9) - SOLValheim.Config.client.y_offset;
        int offset = 0;
        int size = useLargeIcons ? 18 : 9;
        for (ValheimFoodData.EatenFoodItem food : foodData.ItemEntries) {
            FoodHUD.renderFoodSlot(graphics, food, width, size, offset, height, useLargeIcons);
            ++offset;
        }
        if (foodData.DrinkSlot != null) {
            FoodHUD.renderFoodSlot(graphics, foodData.DrinkSlot, width, size, offset, height, useLargeIcons);
        }
    }

    private static void renderFoodSlot(GuiGraphics graphics, ValheimFoodData.EatenFoodItem food, int width, int size, int offset, int height, boolean useLargeIcons) {
        ModConfig.Common.FoodConfig foodConfig = ModConfig.getFoodConfig(food.item);
        if (foodConfig == null) {
            return;
        }
        boolean isDrink = food.item.m_7968_().m_41780_() == UseAnim.DRINK;
        int bgColor = isDrink ? FastColor.ARGB32.m_13660_((int)96, (int)52, (int)104, (int)163) : FastColor.ARGB32.m_13660_((int)96, (int)0, (int)0, (int)0);
        int yellow = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)191, (int)0);
        int startWidth = SOLValheim.Config.client.rightToLeft ? width - size * offset - offset : width + size * offset + offset;
        float ticksLeftPercent = Float.min(1.0f, (float)food.ticksLeft / (float)foodConfig.getTime());
        int barHeight = Integer.max(1, (int)(((float)size + 2.0f) * ticksLeftPercent));
        int barColor = (double)ticksLeftPercent < 0.2 ? FastColor.ARGB32.m_13660_((int)180, (int)255, (int)10, (int)10) : FastColor.ARGB32.m_13660_((int)96, (int)0, (int)255, (int)0);
        float time = (float)food.ticksLeft / 1200.0f;
        float scale = useLargeIcons ? 1.0f : 0.5f;
        boolean isSeconds = false;
        String minutes = String.format("%.0f", Float.valueOf(time));
        if (time < 1.0f) {
            isSeconds = true;
            time = (float)food.ticksLeft / 20.0f;
        }
        PoseStack pose = graphics.m_280168_();
        FoodHUD.fill(graphics, startWidth, height, startWidth + size, height + size, bgColor);
        FoodHUD.fill(graphics, startWidth, Integer.max(height, height - barHeight + size), startWidth + size, height + size, barColor);
        pose.m_85836_();
        pose.m_85841_(scale, scale, scale);
        pose.m_252880_((float)startWidth * (useLargeIcons ? 0.0f : 1.0f), (float)height * (useLargeIcons ? 0.0f : 1.0f), 0.0f);
        if (food.item == Items.f_42502_ && Platform.isModLoaded((String)"farmersdelight")) {
            Item cakeSlice = (Item)SOLValheim.ITEMS.getRegistrar().get(new ResourceLocation("farmersdelight:cake_slice"));
            FoodHUD.renderGUIItem(graphics, new ItemStack((ItemLike)(cakeSlice == null ? food.item : cakeSlice), 1), startWidth + 1, height + 1);
        } else {
            FoodHUD.renderGUIItem(graphics, new ItemStack((ItemLike)food.item, 1), startWidth + 1, height + 1);
        }
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 200.0f);
        FoodHUD.drawFont(graphics, minutes, startWidth + (minutes.length() > 1 ? 6 : 12), height + 10, isSeconds ? FastColor.ARGB32.m_13660_((int)255, (int)237, (int)57, (int)57) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        if (!foodConfig.extraEffects.isEmpty()) {
            FoodHUD.drawFont(graphics, "+" + foodConfig.extraEffects.size(), startWidth + 6, height, yellow);
        }
        pose.m_85849_();
        pose.m_85849_();
    }

    private static void fill(GuiGraphics graphics, int width, int height, int x, int y, int color) {
        graphics.m_280509_(width, height, x, y, color);
    }

    private static void renderGUIItem(GuiGraphics graphics, ItemStack stack, int x, int y) {
        graphics.m_280480_(stack, x, y);
    }

    private static void drawFont(GuiGraphics graphics, String str, int x, int y, int color) {
        graphics.m_280488_(FoodHUD.client.f_91062_, str, x, y, color);
    }

    static {
        HudHeight = 10;
    }
}

