/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.lunarevent;

import corgitaco.enhancedcelestials.api.lunarevent.LunarDimensionSettings;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.api.lunarevent.LunarTextComponents;
import corgitaco.enhancedcelestials.lunarevent.LunarEventInstance;
import corgitaco.enhancedcelestials.lunarevent.LunarForecast;
import corgitaco.enhancedcelestials.network.LunarForecastChangedPacket;
import corgitaco.enhancedcelestials.platform.services.IPlatformHelper;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ServerLunarForecast
extends LunarForecast {
    public ServerLunarForecast(ServerLevel level, Holder<LunarDimensionSettings> lunarDimensionSettingsHolder) {
        super((Level)level, lunarDimensionSettingsHolder);
    }

    @Override
    public void tick() {
        boolean[] sendPacket = new boolean[1];
        this.forecast.removeIf(lunarEventInstance -> {
            if (lunarEventInstance.passed(this.getCurrentDay())) {
                this.pastEvents.add(0, lunarEventInstance);
                sendPacket[0] = true;
                return true;
            }
            if (lunarEventInstance.scheduledDay() > this.getCurrentDay() + ((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).yearLengthInDays()) {
                sendPacket[0] = true;
                return true;
            }
            return false;
        });
        this.pastEvents.removeIf(lunarEventInstance -> {
            if (lunarEventInstance.scheduledDay() > this.getCurrentDay()) {
                sendPacket[0] = true;
                return true;
            }
            if (lunarEventInstance.scheduledDay() < this.getCurrentDay() - ((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).yearLengthInDays()) {
                sendPacket[0] = true;
                return true;
            }
            return false;
        });
        super.tick();
        this.createOrUpdateForecast(this.lastCheckedDay, sendPacket);
        this.checkEmptyForecastOrThrow();
        if (sendPacket[0]) {
            IPlatformHelper.PLATFORM.sendToAllClients(((ServerLevel)this.level).m_6907_(), new LunarForecastChangedPacket(this));
        }
    }

    @Override
    public void eventSwitched(Holder<LunarEvent> lastEvent, Holder<LunarEvent> nextEvent) {
        super.eventSwitched(lastEvent, nextEvent);
        for (Player player : this.level.m_6907_()) {
            ((LunarEvent)lastEvent.m_203334_()).getTextComponents().setNotification().ifPresent(notification -> {
                if (notification.notificationType() != LunarTextComponents.NotificationType.NONE) {
                    player.m_5661_(notification.customTranslationTextComponent().getComponent(), notification.notificationType() == LunarTextComponents.NotificationType.HOT_BAR);
                }
            });
            ((LunarEvent)nextEvent.m_203334_()).getTextComponents().riseNotification().ifPresent(notification -> {
                if (notification.notificationType() != LunarTextComponents.NotificationType.NONE) {
                    player.m_5661_(notification.customTranslationTextComponent().getComponent(), notification.notificationType() == LunarTextComponents.NotificationType.HOT_BAR);
                }
            });
        }
    }

    private void checkEmptyForecastOrThrow() {
        if (this.forecast.isEmpty() && ((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).yearLengthInDays() > ((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).maxDaysBetweenEvents()) {
            throw new IllegalStateException("Forecast cannot be empty.... this should be impossible.... crashing game..... Report this to the Enhanced Celestials Github immediately, please provide your current world instance + other mods.");
        }
    }

    public void recomputeForecast() {
        this.forecast.clear();
        this.createOrUpdateForecast(this.getCurrentDay(), new boolean[1]);
        IPlatformHelper.PLATFORM.sendToAllClients(((ServerLevel)this.level).m_6907_(), new LunarForecastChangedPacket(this));
    }

    public void setLunarEvent(ResourceKey<LunarEvent> lunarEvent) {
        LunarEventInstance first;
        if (!this.level.m_46462_()) {
            ((ServerLevel)this.level).m_8615_(this.getCurrentDay() * ((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).dayLength() + 13000L);
        }
        if ((first = (LunarEventInstance)this.forecast.get(0)).active(this.getCurrentDay())) {
            this.forecast.remove(0);
        }
        if (lunarEvent != ((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).defaultEvent()) {
            this.forecast.add(0, new LunarEventInstance(lunarEvent, this.getCurrentDay(), true));
        }
        IPlatformHelper.PLATFORM.sendToAllClients(((ServerLevel)this.level).m_6907_(), new LunarForecastChangedPacket(this));
    }

    private void createOrUpdateForecast(long lastCheckedDay, boolean[] sendPacket) {
        long dayDifference;
        long yearLengthInDays = ((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).yearLengthInDays();
        if (this.getCurrentDay() < lastCheckedDay - yearLengthInDays) {
            this.lastCheckedDay = lastCheckedDay = this.getCurrentDay();
            sendPacket[0] = true;
        }
        if ((dayDifference = ServerLunarForecast.clamp(lastCheckedDay - this.getCurrentDay(), 0L, yearLengthInDays)) < yearLengthInDays) {
            Object2LongArrayMap<ResourceKey<LunarEvent>> eventsByDay = this.eventsByDay();
            long lastScheduledEventDay = this.lastScheduledEventDay();
            long yearDayDifference = yearLengthInDays - dayDifference;
            int dayOffset = 0;
            while ((long)dayOffset <= yearDayDifference) {
                long day = this.getCurrentDay() + dayDifference + (long)dayOffset;
                long seed = day + ((ServerLevel)this.level).m_7328_() + (long)this.level.m_46472_().hashCode();
                Random random = new Random(seed);
                ArrayList scrambledLunarEvents = new ArrayList(this.lunarEventSpawnRequirements.keySet());
                Collections.shuffle(scrambledLunarEvents, random);
                for (Holder scrambledLunarEvent : scrambledLunarEvents) {
                    boolean override;
                    LunarEvent.SpawnRequirements spawnRequirements = (LunarEvent.SpawnRequirements)this.lunarEventSpawnRequirements.get((Object)scrambledLunarEvent);
                    boolean pastMinNumberOfNightsBetweenThisTypeOfEvent = day - eventsByDay.getOrDefault(scrambledLunarEvent.m_203543_().orElseThrow(), this.getCurrentDay()) > (long)spawnRequirements.minNumberOfNights();
                    boolean pastMinNumberOfNightsBetweenAllEvents = day - lastScheduledEventDay > ((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).minDaysBetweenEvents();
                    boolean isValidMoonPhase = spawnRequirements.validMoonPhases().contains(this.level.m_6042_().m_63936_(this.getDayTimeFromDay(day)));
                    boolean chance = spawnRequirements.chance() >= random.nextDouble();
                    boolean checksPass = pastMinNumberOfNightsBetweenThisTypeOfEvent && pastMinNumberOfNightsBetweenAllEvents && isValidMoonPhase && chance;
                    boolean bl = override = !checksPass && lastScheduledEventDay != -1L && day - lastScheduledEventDay >= ((LunarDimensionSettings)this.dimensionSettingsHolder.m_203334_()).maxDaysBetweenEvents();
                    if (!checksPass && !override) continue;
                    lastScheduledEventDay = day;
                    LunarEventInstance newLunarEventInstance = new LunarEventInstance((ResourceKey<LunarEvent>)((ResourceKey)scrambledLunarEvent.m_203543_().orElseThrow()), day);
                    eventsByDay.put(newLunarEventInstance.getLunarEventKey(), day);
                    this.forecast.add(newLunarEventInstance);
                }
                ++dayOffset;
            }
            this.lastCheckedDay = this.getCurrentDay() + yearLengthInDays;
            sendPacket[0] = true;
        }
    }

    public static long clamp(long value, long min, long max) {
        return value < min ? min : Math.min(value, max);
    }
}

