/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.forge.mixin.world.level.storage.loot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import corgitaco.enhancedcelestials.EnhancedCelestials;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LootDataManager.class})
public abstract class MixinLootTableManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    @Inject(method={"m_278660_(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/world/level/storage/loot/LootDataType;Ljava/util/Map;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/packs/resources/SimpleJsonResourceReloadListener;m_278771_(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/lang/String;Lcom/google/gson/Gson;Ljava/util/Map;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void appendTables(ResourceManager resourceManager, LootDataType $$1x, Map<LootDataType<?>, Map<ResourceLocation, ?>> typeMapMap, CallbackInfo ci, Map<ResourceLocation, JsonElement> values) {
        String appendTablesDir = "append_loot_tables";
        Map resourceMap = resourceManager.m_214159_(appendTablesDir, key -> key.toString().endsWith(".json"));
        for (ResourceLocation resourceLocation : resourceMap.keySet()) {
            ResourceLocation key2 = new ResourceLocation(resourceLocation.m_135815_().replace(appendTablesDir + "/", "").replaceFirst("/", ":").replace(".json", ""));
            if (!values.containsKey(key2)) continue;
            values.get(key2).getAsJsonObject().getAsJsonArray("pools").addAll(MixinLootTableManager.extractPools(resourceManager, resourceLocation));
        }
    }

    private static JsonArray extractPools(ResourceManager resourceManager, ResourceLocation location) {
        try {
            Optional optionalResource = resourceManager.m_213713_(location);
            if (optionalResource.isPresent()) {
                Resource appendedTable = (Resource)optionalResource.get();
                InputStream inputstream = appendedTable.m_215507_();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                JsonElement appendedElement = (JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                return appendedElement.getAsJsonObject().getAsJsonArray("pools");
            }
        }
        catch (IOException e) {
            EnhancedCelestials.LOGGER.error("Could not read appended table:" + String.valueOf(location));
            e.printStackTrace();
        }
        return new JsonArray();
    }
}

