/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.core;

import corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import corgitaco.enhancedcelestials.api.lunarevent.LunarDimensionSettings;
import corgitaco.enhancedcelestials.lunarevent.LunarForecast;
import corgitaco.enhancedcelestials.lunarevent.ServerLunarForecast;
import corgitaco.enhancedcelestials.meteor.MeteorContext;
import corgitaco.enhancedcelestials.save.LunarForecastSavedData;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.jetbrains.annotations.Nullable;

public class EnhancedCelestialsContext {
    private final LunarForecast lunarForecast;
    @Nullable
    private final MeteorContext meteorContext;

    private EnhancedCelestialsContext(LunarForecast forecast) {
        this.lunarForecast = forecast;
        this.meteorContext = null;
    }

    @Nullable
    public static EnhancedCelestialsContext forLevel(Level level, Optional<LunarForecast.Data> saveData) {
        ResourceLocation location;
        Registry lunarDimensionSettingsRegistry = level.m_9598_().m_175515_(EnhancedCelestialsRegistry.LUNAR_DIMENSION_SETTINGS_KEY);
        Optional possibleLunarDimensionSettings = lunarDimensionSettingsRegistry.m_203636_(ResourceKey.m_135785_(EnhancedCelestialsRegistry.LUNAR_DIMENSION_SETTINGS_KEY, (ResourceLocation)(location = level.m_46472_().m_135782_())));
        if (possibleLunarDimensionSettings.isPresent()) {
            Holder lunarDimensionSettings = (Holder)possibleLunarDimensionSettings.get();
            LunarForecast forecast = !level.f_46443_ ? new ServerLunarForecast((ServerLevel)level, (Holder<LunarDimensionSettings>)lunarDimensionSettings) : new LunarForecast(level, (Holder<LunarDimensionSettings>)lunarDimensionSettings);
            LunarForecast.Data forecastData = saveData.orElseGet(() -> LunarForecastSavedData.get((LevelAccessor)level).getForecastSaveData());
            if (forecastData != null) {
                forecast.loadData(forecastData);
            }
            return new EnhancedCelestialsContext(forecast);
        }
        return null;
    }

    public void tick(Level world) {
        this.lunarForecast.tick();
        if (world.m_46467_() % 2400L == 0L) {
            this.save(world);
        }
    }

    public void chunkTick(Level level, ChunkAccess chunkAccess) {
        if (this.meteorContext != null) {
            this.meteorContext.chunkTick(level, chunkAccess);
        }
    }

    public void save(Level world) {
        LunarForecastSavedData.get((LevelAccessor)world).setForecastSaveData(this.lunarForecast.saveData());
    }

    public LunarForecast getLunarForecast() {
        return this.lunarForecast;
    }
}

