/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import java.util.Optional;
import net.minecraftforge.fml.ModList;

public class Platform {
    public static Optional<Object> maybeLoadIntegration(String modid, String path) {
        if (!ModList.get().isLoaded(modid)) {
            AdvancedPeripherals.LOGGER.info("{} not loaded, skip integration loading", (Object)modid);
            return Optional.empty();
        }
        return Platform.maybeLoadIntegration(path);
    }

    public static Optional<Object> maybeLoadIntegration(String path) {
        try {
            Class<?> clazz = Class.forName(AdvancedPeripherals.class.getPackage().getName() + ".common.addons." + path);
            return Optional.of(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException loadException) {
            if (((Boolean)APConfig.GENERAL_CONFIG.enableDebugMode.get()).booleanValue()) {
                loadException.printStackTrace();
            }
            return Optional.empty();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

