/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.base;

import de.srendi.advancedperipherals.common.blocks.base.BaseBlock;
import de.srendi.advancedperipherals.common.blocks.base.IInventoryBlock;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBlockEntityBlock
extends BaseBlock
implements EntityBlock {
    private final boolean belongToTickingEntity;

    public BaseBlockEntityBlock(boolean belongToTickingEntity) {
        this(belongToTickingEntity, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_284268_(DyeColor.GRAY).m_60913_(1.0f, 5.0f).m_60918_(SoundType.f_56743_).m_60955_().m_60999_());
    }

    public BaseBlockEntityBlock(boolean belongToTickingEntity, BlockBehaviour.Properties properties) {
        super(properties, (TagKey<Block>)BlockTags.f_144285_);
        this.belongToTickingEntity = belongToTickingEntity;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level levelIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (levelIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = levelIn.m_7702_(pos);
        if (tileEntity != null && !(tileEntity instanceof IInventoryBlock)) {
            return InteractionResult.PASS;
        }
        MenuProvider namedContainerProvider = this.m_7246_(state, levelIn, pos);
        if (namedContainerProvider != null) {
            if (!(player instanceof ServerPlayer)) {
                return InteractionResult.PASS;
            }
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)namedContainerProvider, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            if (tileEntity instanceof Container) {
                Container container = (Container)tileEntity;
                Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)container);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (worldIn.m_7702_(pos) == null) {
            return;
        }
        if (stack.m_41788_() && (blockEntity = worldIn.m_7702_(pos)) instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity blockEntity2 = (BaseContainerBlockEntity)blockEntity;
            blockEntity2.m_58638_(stack.m_41786_());
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        if (level.f_46443_ || !this.belongToTickingEntity) {
            return null;
        }
        return (level1, blockPos, blockState, entity) -> {
            if (entity instanceof IPeripheralTileEntity) {
                IPeripheralTileEntity blockEntity = (IPeripheralTileEntity)entity;
                blockEntity.handleTick(level, state, type);
            }
        };
    }

    @Deprecated
    @Nullable
    public MenuProvider m_7246_(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (!(blockentity instanceof MenuProvider)) {
            return null;
        }
        MenuProvider menuProvider = (MenuProvider)blockentity;
        return menuProvider;
    }

    @Override
    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }
}

