/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientInstanceWrapper;
import org.cyclops.cyclopscore.ingredient.collection.IngredientSet;

public class IngredientHashSet<T, M>
extends IngredientSet<T, M> {
    public IngredientHashSet(IngredientComponent<T, M> component) {
        this(component, Sets.newHashSet());
    }

    public IngredientHashSet(IngredientComponent<T, M> component, int expectedSize) {
        super(component, Sets.newHashSetWithExpectedSize((int)expectedSize));
    }

    public IngredientHashSet(IngredientComponent<T, M> component, Iterable<? extends T> iterable) {
        super(component, iterable instanceof Collection ? Sets.newHashSetWithExpectedSize((int)((Collection)iterable).size()) : Sets.newHashSet());
        this.addAll(iterable);
    }

    public IngredientHashSet(IngredientComponent<T, M> component, Iterator<? extends T> iterable) {
        this(component);
        while (iterable.hasNext()) {
            this.add(iterable.next());
        }
    }

    public IngredientHashSet(IngredientComponent<T, M> component, HashSet<IngredientInstanceWrapper<T, M>> set) {
        super(component, set);
    }
}

