/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.HyperLink;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.packet.RequestPlayerNbtPacket;

public abstract class ScreenInfoBook<T extends ContainerExtended>
extends AbstractContainerScreen<T> {
    private static final int HR_WIDTH = 88;
    private static final int HR_HEIGHT = 10;
    private static final int BANNER_WIDTH = 91;
    private static final int BANNER_HEIGHT = 12;
    private static final int ARROW_WIDTH = 22;
    private static final int ARROW_HEIGHT = 13;
    private static final int BORDER_CORNER = 4;
    private static final int BORDER_WIDTH = 2;
    private static final int BORDER_X = 0;
    private static final int BORDER_Y = 206;
    protected final IInfoBook infoBook;
    protected final ResourceLocation texture;
    protected NextPageButton buttonNextPage;
    protected NextPageButton buttonPreviousPage;
    protected NextPageButton buttonParent;
    protected NextPageButton buttonBack;
    protected NextPageButton buttonExternal;
    private InfoSection nextSection;
    private int nextPage;
    private boolean goToLastPage;
    private int left;
    private int top;

    public ScreenInfoBook(T container, Inventory playerInventory, Component title, IInfoBook infoBook) {
        super(container, playerInventory, title);
        this.infoBook = infoBook;
        this.texture = this.constructGuiTexture();
        if (infoBook.getCurrentSection() == null) {
            InfoSection root = infoBook.getMod().getRegistryManager().getRegistry(IInfoBookRegistry.class).getRoot(infoBook);
            if (root == null) {
                throw new IllegalStateException("Could not find the root of infobook " + String.valueOf(infoBook));
            }
            infoBook.setCurrentSection(root);
            infoBook.setCurrentPage(0);
        }
        CyclopsCore._instance.getPacketHandler().sendToServer(new RequestPlayerNbtPacket());
    }

    protected abstract ResourceLocation constructGuiTexture();

    protected int getPages() {
        return this.infoBook.getPagesPerView();
    }

    protected abstract int getGuiWidth();

    protected abstract int getGuiHeight();

    protected abstract int getPageWidth();

    protected int getPageYOffset() {
        return 16;
    }

    protected int getFootnoteOffsetX() {
        return 10;
    }

    protected int getFootnoteOffsetY() {
        return 0;
    }

    protected int getPrevNextOffsetY() {
        return 0;
    }

    protected int getPrevNextOffsetX() {
        return 0;
    }

    public int getTitleColor() {
        return Helpers.RGBToInt(120, 20, 30);
    }

    public void m_7856_() {
        int page;
        super.m_7856_();
        this.m_169413_();
        this.left = (this.f_96543_ - this.getGuiWidth()) / 2;
        this.top = (this.f_96544_ - this.getGuiHeight()) / 2;
        this.f_97726_ = this.getGuiWidth();
        this.f_97727_ = this.getGuiHeight();
        this.buttonNextPage = new NextPageButton(this.left + this.getPageWidth() + 100 + this.getPrevNextOffsetX(), this.top + 156 + this.getPrevNextOffsetY(), 0, 180, 18, 10, button -> {
            InfoSection.Location location = this.infoBook.getCurrentSection().getNext(this.infoBook.getCurrentPage() + this.getPages() - 1, MinecraftHelpers.isShifted());
            this.goToLastPage = false;
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
            this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
            this.applyNavigation();
        }, this);
        this.m_142416_((GuiEventListener)this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(this.left + 23 - this.getPrevNextOffsetX(), this.top + 156 + this.getPrevNextOffsetY(), 0, 193, 18, 10, button -> {
            InfoSection.Location location = this.infoBook.getCurrentSection().getPrevious(this.infoBook.getCurrentPage(), MinecraftHelpers.isShifted());
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
            this.goToLastPage = this.nextSection != this.infoBook.getCurrentSection() && !MinecraftHelpers.isShifted();
            this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
            this.applyNavigation();
        }, this);
        this.m_142416_((GuiEventListener)this.buttonPreviousPage);
        this.buttonParent = new NextPageButton(this.left + 2, this.top + 2, 36, 180, 8, 8, button -> {
            this.goToLastPage = false;
            if (MinecraftHelpers.isShifted()) {
                this.nextSection = this.infoBook.getCurrentSection().getParent();
                while (this.nextSection.getParent() != null) {
                    this.nextSection = this.nextSection.getParent();
                }
            } else {
                this.nextSection = this.infoBook.getCurrentSection().getParent();
            }
            this.nextPage = 0;
            this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
            this.applyNavigation();
        }, this);
        this.m_142416_((GuiEventListener)this.buttonParent);
        this.buttonBack = new NextPageButton(this.left + this.getPageWidth() + 127, this.top + 2, 0, 223, 13, 18, button -> {
            InfoSection.Location location = this.infoBook.getHistory().pop();
            this.goToLastPage = false;
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
            this.applyNavigation();
        }, this);
        this.m_142416_((GuiEventListener)this.buttonBack);
        this.buttonExternal = new NextPageButton(this.left + 130, this.top, 26, 203, 11, 11, button -> Helpers.openUrl(this.infoBook.getBaseUrl() + this.infoBook.getCurrentSection().getRelativeWebPath()), this);
        this.m_142416_((GuiEventListener)this.buttonExternal);
        this.updateGui();
        if (this.goToLastPage) {
            page = Math.max(0, this.infoBook.getCurrentSection().getPages() - this.getPages());
            page += page % this.getPages();
            this.infoBook.setCurrentPage(page);
        }
        for (int innerPage = page = this.infoBook.getCurrentPage(); innerPage <= page + this.getPages() - 1; ++innerPage) {
            for (HyperLink link : this.infoBook.getCurrentSection().getLinks(innerPage)) {
                if (link.getTranslationKey().equals(L10NHelpers.localize(link.getTranslationKey(), new Object[0]))) {
                    CyclopsCore.clog(Level.WARN, "Could not find hyperlink localization for " + link.getTranslationKey());
                }
                int xOffset = this.getOffsetXForPageWithWidths(innerPage % this.getPages());
                this.m_142416_((GuiEventListener)new TextOverlayButton(link, this.left + xOffset + link.getX(), this.top + this.getPageYOffset() / 2 + link.getY(), InfoSection.getFontHeight(this.getFont()), this.getPageWidth() - this.getOffsetXTotal() - link.getX(), button -> {
                    this.goToLastPage = false;
                    this.nextSection = ((TextOverlayButton)button).getLink().getTarget();
                    this.nextPage = 0;
                    if (this.nextSection != this.infoBook.getCurrentSection()) {
                        this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
                    }
                    this.applyNavigation();
                }, this));
            }
            for (AdvancedButton advancedButton : this.infoBook.getCurrentSection().getAdvancedButtons(innerPage)) {
                advancedButton.setOnPress(button -> {
                    this.goToLastPage = false;
                    this.nextSection = ((AdvancedButton)button).getTarget();
                    this.nextPage = 0;
                    if (this.nextSection != this.infoBook.getCurrentSection()) {
                        this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
                    }
                    this.applyNavigation();
                });
                this.m_142416_((GuiEventListener)advancedButton);
            }
        }
    }

    protected abstract int getOffsetXForPageBase(int var1);

    protected int getOffsetXForPageWithWidths(int page) {
        return this.getOffsetXForPageBase(page) + page * this.getPageWidth();
    }

    protected int getOffsetXTotal() {
        int total = 0;
        for (int i = 0; i < this.getPages(); ++i) {
            total += this.getOffsetXForPageBase(i);
        }
        return total;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280218_(this.texture, this.left, this.top, 0, 0, this.getPageWidth(), this.getGuiHeight());
        this.blitMirrored(this.left + this.getPageWidth() - 1, this.top, 0, 0, this.getPageWidth(), this.getGuiHeight());
        int width = this.getPageWidth() - this.getOffsetXTotal();
        for (i = 0; i < this.getPages(); ++i) {
            this.infoBook.getCurrentSection().drawScreen(this, guiGraphics, this.left + this.getOffsetXForPageWithWidths(i), this.top, this.getPageYOffset(), width, this.getGuiHeight(), this.infoBook.getCurrentPage() + i, mouseX, mouseY, this.getFootnoteOffsetX(), this.getFootnoteOffsetY());
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        for (i = 0; i < this.getPages(); ++i) {
            this.infoBook.getCurrentSection().postDrawScreen(this, guiGraphics, this.left + this.getOffsetXForPageWithWidths(i), this.top + this.getPageYOffset(), width, this.getGuiHeight(), this.infoBook.getCurrentPage() + i, mouseX, mouseY);
        }
        if (this.buttonNextPage.f_93624_ && RenderHelpers.isPointInButton(this.buttonNextPage, mouseX, mouseY)) {
            this.drawTooltip(guiGraphics, mouseX, mouseY, (Component)Component.m_237115_((String)"infobook.cyclopscore.next_page"));
        }
        if (this.buttonPreviousPage.f_93624_ && RenderHelpers.isPointInButton(this.buttonPreviousPage, mouseX, mouseY)) {
            this.drawTooltip(guiGraphics, mouseX, mouseY, (Component)Component.m_237115_((String)"infobook.cyclopscore.previous_page"));
        }
        if (this.buttonBack.f_93624_ && RenderHelpers.isPointInButton(this.buttonBack, mouseX, mouseY)) {
            this.drawTooltip(guiGraphics, mouseX, mouseY, (Component)Component.m_237115_((String)"infobook.cyclopscore.last_page"));
        }
        if (this.buttonParent.f_93624_ && RenderHelpers.isPointInButton(this.buttonParent, mouseX, mouseY)) {
            this.drawTooltip(guiGraphics, mouseX, mouseY, (Component)Component.m_237115_((String)"infobook.cyclopscore.parent_section"));
        }
        if (this.buttonExternal.f_93624_ && RenderHelpers.isPointInButton(this.buttonExternal, mouseX, mouseY)) {
            this.drawTooltip(guiGraphics, mouseX, mouseY, (Component)Component.m_237115_((String)"infobook.cyclopscore.external"));
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
    }

    protected void m_280003_(GuiGraphics guiGraphics, int x, int y) {
    }

    public void drawTooltip(GuiGraphics guiGraphics, int mx, int my, Component lines) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280557_(this.getFont(), lines, mx, my);
        guiGraphics.m_280168_().m_85849_();
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
    }

    public void blitMirrored(int x, int y, int u, int v, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder worldRenderer = tessellator.m_85915_();
        worldRenderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        boolean z = false;
        worldRenderer.m_5483_((double)(x + 0), (double)(y + height), (double)z).m_7421_((float)(u + width) * f, (float)(v + height) * f1).m_5752_();
        worldRenderer.m_5483_((double)(x + width), (double)(y + height), (double)z).m_7421_((float)(u + 0) * f, (float)(v + height) * f1).m_5752_();
        worldRenderer.m_5483_((double)(x + width), (double)(y + 0), (double)z).m_7421_((float)(u + 0) * f, (float)(v + 0) * f1).m_5752_();
        worldRenderer.m_5483_((double)(x + 0), (double)(y + 0), (double)z).m_7421_((float)(u + width) * f, (float)(v + 0) * f1).m_5752_();
        tessellator.m_85914_();
    }

    public boolean m_7043_() {
        return false;
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public int getBannerWidth() {
        return 91;
    }

    private void updateGui() {
        int width = this.getPageWidth() - this.getOffsetXTotal();
        int lineHeight = InfoSection.getFontHeight(this.getFont());
        int maxLines = (this.getGuiHeight() - 2 * this.getPageYOffset() - 5) / lineHeight;
        LinkedList infoSectionsToBake = Lists.newLinkedList();
        infoSectionsToBake.add(this.infoBook.getCurrentSection());
        this.getPreviousSections(infoSectionsToBake);
        this.getNextSections(infoSectionsToBake);
        for (InfoSection infoSection : infoSectionsToBake) {
            if (infoSection == null) continue;
            infoSection.bakeSection(this.getFont(), width, maxLines, lineHeight, this.getPageYOffset());
        }
        this.updateButtons();
    }

    protected void getPreviousSections(List<InfoSection> sections) {
        InfoSection.Location location = this.infoBook.getCurrentSection().getPrevious(this.infoBook.getCurrentPage(), false);
        if (location != null) {
            sections.add(location.getInfoSection());
        }
    }

    protected void getNextSections(List<InfoSection> sections) {
        InfoSection.Location location = this.infoBook.getCurrentSection().getNext(this.infoBook.getCurrentPage() + this.getPages() - 1, false);
        if (location != null) {
            sections.add(location.getInfoSection());
        }
    }

    private void updateButtons() {
        InfoSection.Location current1 = new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection());
        InfoSection.Location current2 = new InfoSection.Location(this.infoBook.getCurrentPage() + this.getPages() - 1, this.infoBook.getCurrentSection());
        InfoSection.Location wouldBeNext = this.infoBook.getCurrentSection().getNext(this.infoBook.getCurrentPage() + this.getPages() - 1, false);
        this.buttonNextPage.f_93624_ = !current1.equals(wouldBeNext) && !current2.equals(wouldBeNext);
        this.buttonPreviousPage.f_93624_ = !current1.equals(this.infoBook.getCurrentSection().getPrevious(this.infoBook.getCurrentPage(), false));
        this.buttonParent.f_93624_ = this.infoBook.getCurrentSection() != null && this.infoBook.getCurrentSection().getParent() != null;
        this.buttonBack.f_93624_ = this.infoBook.getHistory().currentSize() > 0;
    }

    protected void applyNavigation() {
        if (this.nextSection != null && (this.nextSection != this.infoBook.getCurrentSection() || this.infoBook.getCurrentPage() != this.nextPage)) {
            this.infoBook.setCurrentSection(this.nextSection);
            this.nextSection = null;
            this.infoBook.setCurrentPage(this.nextPage);
            this.m_7856_();
        }
    }

    public void drawScaledCenteredString(GuiGraphics guiGraphics, String string, int x, int y, int width, float originalScale, int maxWidth, int color) {
        this.drawScaledCenteredString(guiGraphics, string, x, y, width, originalScale, maxWidth, color, false);
    }

    public void drawScaledCenteredString(GuiGraphics guiGraphics, String string, int x, int y, int width, float originalScale, int maxWidth, int color, boolean shadow) {
        float originalWidth = (float)this.getFont().m_92895_(string) * originalScale;
        float scale = Math.min(originalScale, (float)maxWidth / originalWidth * originalScale);
        this.drawScaledCenteredString(guiGraphics, string, x, y, width, scale, color, shadow);
    }

    public void drawScaledCenteredString(GuiGraphics guiGraphics, String string, int x, int y, int width, float scale, int color) {
        this.drawScaledCenteredString(guiGraphics, string, x, y, width, scale, color, false);
    }

    public void drawScaledCenteredString(GuiGraphics guiGraphics, String string, int x, int y, int width, float scale, int color, boolean shadow) {
        PoseStack matrixStack = guiGraphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_85841_(scale, scale, 1.0f);
        int titleLength = this.f_96547_.m_92895_(string);
        Objects.requireNonNull(this.f_96547_);
        int titleHeight = 9;
        if (shadow) {
            this.f_96547_.m_271703_(string, (float)Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), (float)Math.round((float)y / scale - (float)(titleHeight / 2)), color, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else {
            this.f_96547_.m_271703_(string, (float)Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), (float)Math.round((float)y / scale - (float)(titleHeight / 2)), color, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        matrixStack.m_85849_();
    }

    public void drawHorizontalRule(GuiGraphics guiGraphics, int x, int y) {
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
        guiGraphics.m_280218_(this.texture, x - 44, y - 5, 52, 180, 88, 10);
        GlStateManager._disableBlend();
    }

    public void drawTextBanner(GuiGraphics guiGraphics, int x, int y) {
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
        guiGraphics.m_280218_(this.texture, x - 45, y - 6, 52, 191, 91, 12);
        GlStateManager._disableBlend();
    }

    public void drawArrowRight(GuiGraphics guiGraphics, int x, int y) {
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
        guiGraphics.m_280218_(this.texture, x, y, 0, 210, 22, 13);
        GlStateManager._disableBlend();
    }

    public void drawOuterBorder(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        this.drawOuterBorder(guiGraphics, x, y, width, height, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawOuterBorder(GuiGraphics guiGraphics, int x, int y, int width, int height, float r, float g, float b, float alpha) {
        int i;
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
        RenderHelpers.bindTexture(this.texture);
        int z = 0;
        RenderHelpers.blitColored(guiGraphics, x - 2, y - 2, z, 0.0f, 206.0f, 4, 4, r, g, b, alpha);
        RenderHelpers.blitColored(guiGraphics, x + width - 2, y - 2, z, 4.0f, 206.0f, 4, 4, r, g, b, alpha);
        RenderHelpers.blitColored(guiGraphics, x - 2, y + height - 2, z, 12.0f, 206.0f, 4, 4, r, g, b, alpha);
        RenderHelpers.blitColored(guiGraphics, x + width - 2, y + height - 2, z, 8.0f, 206.0f, 4, 4, r, g, b, alpha);
        for (i = 2; i < width - 2; i += 2) {
            int drawWidth = 2;
            if (i + 2 >= width - 4) {
                drawWidth -= i - (width - 4);
            }
            RenderHelpers.blitColored(guiGraphics, x + i, y - 2, z, 16.0f, 206.0f, drawWidth, 2, r, g, b, alpha);
            RenderHelpers.blitColored(guiGraphics, x + i, y + height, z, 16.0f, 206.0f, drawWidth, 2, r, g, b, alpha);
        }
        for (i = 2; i < height - 2; i += 2) {
            int drawHeight = 2;
            if (i + 2 >= height - 4) {
                drawHeight -= i - (height - 4);
            }
            if (drawHeight <= 0) continue;
            RenderHelpers.blitColored(guiGraphics, x - 2, y + i, z, 16.0f, 206.0f, 2, drawHeight, r, g, b, alpha);
            RenderHelpers.blitColored(guiGraphics, x + width, y + i, z, 16.0f, 206.0f, 2, drawHeight, r, g, b, alpha);
        }
    }

    public void renderTooltip(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        guiGraphics.m_280153_(this.getFont(), itemStack, x, y);
    }

    public int getTick() {
        return (int)this.getMinecraft().f_91073_.m_46467_();
    }

    public void m_181908_() {
        super.m_181908_();
        if (!this.f_96541_.f_91074_.m_6084_()) {
            this.f_96541_.f_91074_.m_6915_();
        }
    }

    public abstract void playPageFlipSound(SoundManager var1);

    public abstract void playPagesFlipSound(SoundManager var1);

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (scrollDelta < 0.0) {
            this.buttonNextPage.m_5716_(mouseX, mouseY);
            return true;
        }
        if (scrollDelta > 0.0) {
            this.buttonPreviousPage.m_5716_(mouseX, mouseY);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class NextPageButton
    extends Button {
        private final ScreenInfoBook guiInfoBook;
        private int textureX;
        private int textureY;

        public NextPageButton(int x, int y, int textureX, int textureY, int width, int height, Button.OnPress onPress, ScreenInfoBook guiInfoBook) {
            super(x, y, width, height, (Component)Component.m_237113_((String)""), onPress, Button.f_252438_);
            this.textureX = textureX;
            this.textureY = textureY;
            this.guiInfoBook = guiInfoBook;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                boolean isHover = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
                int k = this.textureX;
                int l = this.textureY;
                if (isHover) {
                    k += this.f_93618_;
                }
                GlStateManager._enableBlend();
                GlStateManager._blendFunc((int)770, (int)771);
                guiGraphics.m_280218_(this.guiInfoBook.texture, this.m_252754_(), this.m_252907_(), k, l, this.f_93618_, this.f_93619_);
                GlStateManager._disableBlend();
            }
        }

        public void m_7435_(SoundManager soundHandler) {
            this.guiInfoBook.playPageFlipSound(soundHandler);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class TextOverlayButton
    extends Button {
        private final ScreenInfoBook guiInfoBook;
        private HyperLink link;

        public TextOverlayButton(HyperLink link, int x, int y, int height, int maxWidth, Button.OnPress onPress, ScreenInfoBook guiInfoBook) {
            super(x, y, 0, height, (Component)Component.m_237113_((String)InfoSection.formatString(L10NHelpers.localize(link.getTranslationKey(), new Object[0]))), onPress, Button.f_252438_);
            this.guiInfoBook = guiInfoBook;
            this.link = link;
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            this.f_93618_ = fontRenderer.m_92724_(this.m_6035_().m_7532_());
            if (this.f_93618_ > maxWidth) {
                Object originalMessage = this.m_6035_().getString();
                originalMessage = ((String)originalMessage).substring(0, (int)((float)maxWidth / (float)this.f_93618_ * (float)((String)originalMessage).length()) - 1);
                originalMessage = (String)originalMessage + "\u2026";
                this.m_93666_((Component)Component.m_237113_((String)originalMessage));
                this.f_93618_ = maxWidth;
            }
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                boolean isHover = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
                Minecraft minecraft = Minecraft.m_91087_();
                MutableComponent msg = (MutableComponent)this.m_6035_();
                if (isHover) {
                    msg = msg.m_130940_(ChatFormatting.UNDERLINE);
                }
                minecraft.f_91062_.m_272077_((Component)msg, (float)this.m_252754_(), (float)this.m_252907_(), Helpers.RGBToInt(isHover ? 100 : 0, isHover ? 100 : 0, isHover ? 150 : 125), false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
        }

        public void m_7435_(SoundManager soundHandler) {
            this.guiInfoBook.playPagesFlipSound(soundHandler);
        }

        public HyperLink getLink() {
            return this.link;
        }
    }
}

