/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentHelpers {
    public static int doesEnchantApply(ItemStack itemStack, Enchantment enchantment) {
        ListTag enchantmentList = itemStack.m_41785_();
        for (int i = 0; i < enchantmentList.size(); ++i) {
            if (!ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).equals((Object)new ResourceLocation(enchantmentList.m_128728_(i).m_128461_("id")))) continue;
            return i;
        }
        return -1;
    }

    public static int getEnchantmentLevel(ItemStack itemStack, int enchantmentListID) {
        ListTag enchlist = itemStack.m_41785_();
        return enchlist.m_128728_(enchantmentListID).m_128448_("lvl");
    }

    public static Enchantment getEnchantment(ItemStack itemStack, int enchantmentListID) {
        ListTag enchlist = itemStack.m_41785_();
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchlist.m_128728_(enchantmentListID).m_128461_("id")));
    }

    public static void setEnchantmentLevel(ItemStack itemStack, int enchantmentListID, int level) {
        ListTag enchlist = itemStack.m_41785_();
        if (level <= 0) {
            enchlist.remove(enchantmentListID);
            if (enchlist.size() == 0) {
                itemStack.m_41783_().m_128473_("Enchantments");
            }
        } else {
            CompoundTag compound = enchlist.m_128728_(enchantmentListID);
            compound.m_128376_("lvl", (short)level);
        }
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128365_("Enchantments", (Tag)enchlist);
    }

    public static void setEnchantmentLevel(ItemStack itemStack, Enchantment enchantment, int level) {
        int existingIndex = EnchantmentHelpers.doesEnchantApply(itemStack, enchantment);
        if (existingIndex >= 0) {
            EnchantmentHelpers.setEnchantmentLevel(itemStack, existingIndex, level);
        } else {
            itemStack.m_41663_(enchantment, level);
        }
    }
}

