/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.variables;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableProvider;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public class TextVariableParser {
    private final String orig;
    private final IVariableProvider variableProvider;
    private final Set<String> relevantVariables = new HashSet<String>();
    private final UUID playerID;
    private static final Map<String, VariableRetriever> RETRIEVERS = new HashMap<String, VariableRetriever>();

    public TextVariableParser(String str, UUID playerID) {
        this.orig = str;
        this.variableProvider = GlobalVariableHelper.getVariableProvider();
        this.playerID = playerID;
    }

    public TextVariableParser(String str, DroneAIManager droneAIManager) {
        this.orig = str;
        this.variableProvider = droneAIManager;
        this.playerID = droneAIManager.getDrone().getOwnerUUID();
    }

    public String parse() {
        int index;
        Object ret = this.orig;
        while ((index = ((String)ret).indexOf("${")) >= 0) {
            int secondIndex = ((String)ret).indexOf("}", index);
            if (secondIndex >= 0) {
                String varName = ((String)ret).substring(index + 2, secondIndex);
                boolean isItem = !this.variableProvider.getStack(this.playerID, varName).m_41619_() && this.variableProvider.getCoordinate(this.playerID, varName).isEmpty();
                String varValue = this.getVariableValue(varName, isItem);
                ret = ((String)ret).substring(0, index) + varValue + ((String)ret).substring(secondIndex + 1);
                continue;
            }
            return ((String)ret).substring(0, index) + "Parsing error: Missing '}'";
        }
        return ret;
    }

    public Set<String> getRelevantVariables() {
        return this.relevantVariables;
    }

    private String getVariableValue(String varNameWithExt, boolean isItem) {
        String[] f = StringUtils.splitByWholeSeparator((String)varNameWithExt, (String)".", (int)2);
        String varName = f[0];
        String ext = f.length == 2 ? f[1] : (isItem ? "item" : "pos");
        VariableRetriever handler = RETRIEVERS.get(ext);
        if (handler == null) {
            return "";
        }
        this.relevantVariables.add(varName);
        return handler.retrieve(this.variableProvider, this.playerID, varName);
    }

    private static String stackToStr(ItemStack stack, boolean id) {
        if (stack.m_41619_()) {
            return "";
        }
        return id ? PneumaticCraftUtils.getRegistryName(stack.m_41720_()).orElseThrow().toString() : stack.m_41611_().getString();
    }

    static {
        RETRIEVERS.put("pos", (p, id, varName) -> PneumaticCraftUtils.posToString(p.getCoordinate(id, varName).orElse(BlockPos.f_121853_)));
        RETRIEVERS.put("x", (p, id, varName) -> Integer.toString(p.getCoordinate(id, varName).orElse(BlockPos.f_121853_).m_123341_()));
        RETRIEVERS.put("y", (p, id, varName) -> Integer.toString(p.getCoordinate(id, varName).orElse(BlockPos.f_121853_).m_123342_()));
        RETRIEVERS.put("z", (p, id, varName) -> Integer.toString(p.getCoordinate(id, varName).orElse(BlockPos.f_121853_).m_123343_()));
        RETRIEVERS.put("item", (p, id, varName) -> TextVariableParser.stackToStr(p.getStack(id, varName), false));
        RETRIEVERS.put("id", (p, id, varName) -> TextVariableParser.stackToStr(p.getStack(id, varName), true));
    }

    @FunctionalInterface
    private static interface VariableRetriever {
        public String retrieve(IVariableProvider var1, UUID var2, String var3);
    }
}

